/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.message;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mentawai.core.Action;
import org.mentawai.core.Context;
import org.mentawai.core.Output;
import org.mentawai.message.Message;

public class MessageManager {
    public static String ERRORS = "_errors";
    public static String MESSAGES = "_messages";
    public static String FIELDERRORS = "_fieldErrors";

    public static List<Message> getErrors(Action action, boolean create) {
        if (action == null) {
            return null;
        }
        Output output = action.getOutput();
        LinkedList errors = (LinkedList)output.getValue(ERRORS);
        if (errors == null && create) {
            errors = new LinkedList();
            output.setValue(ERRORS, errors);
        }
        return errors;
    }

    public static Map<String, Message> getFieldErrors(Action action, boolean create) {
        if (action == null) {
            return null;
        }
        Output output = action.getOutput();
        LinkedHashMap fieldErrors = (LinkedHashMap)output.getValue(FIELDERRORS);
        if (fieldErrors == null && create) {
            fieldErrors = new LinkedHashMap();
            output.setValue(FIELDERRORS, fieldErrors);
        }
        return fieldErrors;
    }

    public static List<Message> getMessages(Action action, boolean create, boolean flash) {
        if (action == null) {
            return null;
        }
        Output output = action.getOutput();
        LinkedList messages = (LinkedList)output.getValue(MESSAGES);
        if (messages == null && create) {
            messages = new LinkedList();
            output.setValue(MESSAGES, messages);
            if (flash) {
                Context session = action.getSession();
                session.setAttribute("_flash." + MESSAGES, messages);
            }
        }
        return messages;
    }

    public static List<Message> getMessages(Action action, boolean create) {
        return MessageManager.getMessages(action, create, false);
    }
}

