/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.message;

import java.util.Locale;
import org.mentawai.i18n.I18N;
import org.mentawai.i18n.I18NMap;
import org.mentawai.message.MessageContext;

public class ClasspathMessageContext
implements MessageContext {
    private final String resource;

    public ClasspathMessageContext(String resource) {
        this.resource = resource;
    }

    @Override
    public String getMessage(String id, Locale loc) {
        I18N i18n = I18NMap.getI18NFromClasspath(this.resource + "_" + loc.toString());
        I18N i18nLang = I18NMap.getI18NFromClasspath(this.resource + "_" + loc.getLanguage());
        if (i18n != null && i18n.hasKey(id)) {
            return i18n.get(id);
        }
        if (i18nLang != null && i18nLang.hasKey(id)) {
            return i18nLang.get(id);
        }
        return id;
    }

    public String toString() {
        return this.resource;
    }
}

