/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.message;

import java.util.Locale;
import org.mentawai.i18n.I18N;
import org.mentawai.i18n.I18NMap;
import org.mentawai.message.MessageContext;

public abstract class AbstractMessageContext
implements MessageContext {
    private static final String DIR = "/messages";
    protected String dir = "/messages";
    protected String prefix = null;

    public String getDir() {
        return this.dir;
    }

    void setDir(String dir) {
        this.dir = dir;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    protected abstract String getPath();

    @Override
    public String getMessage(String id, Locale loc) {
        I18N i18n = I18NMap.getI18N(this.getPath() + "_" + loc.toString());
        I18N i18nLang = I18NMap.getI18N(this.getPath() + "_" + loc.getLanguage());
        StringBuilder idWithPrefix = new StringBuilder(32);
        if (this.prefix != null) {
            idWithPrefix.append(this.prefix).append('.');
        }
        idWithPrefix.append(id);
        String newId = idWithPrefix.toString();
        if (i18n != null && i18n.hasKey(newId)) {
            return i18n.get(newId);
        }
        if (i18nLang != null && i18nLang.hasKey(newId)) {
            return i18nLang.get(newId);
        }
        return id;
    }

    public String toString() {
        return this.getPath();
    }
}

