/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.message;

import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mentawai.list.ListData;
import org.mentawai.list.ListManager;
import org.mentawai.message.Message;
import org.mentawai.message.MessageContext;

public abstract class AbstractMessage
implements Message {
    private static final String TOKEN_MARKER = "%";
    private static final String LIST_MARKER = "@";
    private static final String I18N_MARKER = "!";
    private static final String REGEX = "\\@([^\\@]+)\\@";
    private static final String PARAM_REGEX = "\\{([0-9]+)\\}";
    private static final String I18N_REGEX = "\\!([^\\!]+)\\!";
    private static final Pattern PATTERN = Pattern.compile("\\@([^\\@]+)\\@");
    private static final Pattern PARAM_PATTERN = Pattern.compile("\\{([0-9]+)\\}");
    private static final Pattern I18N_PATTERN = Pattern.compile("\\!([^\\!]+)\\!");
    protected String id;
    protected MessageContext context;
    protected Map<String, String> tokens = null;
    protected String tokenMarker = "%";
    protected String[] params = null;

    public AbstractMessage(String id, MessageContext context) {
        this.id = id;
        this.context = context;
    }

    public AbstractMessage(String id, MessageContext context, Map<String, String> tokens) {
        this(id, context);
        this.tokens = tokens;
    }

    public AbstractMessage(String id, MessageContext context, Map<String, String> tokens, String[] params) {
        this(id, context, tokens);
        this.params = params;
    }

    public AbstractMessage(int id, MessageContext context) {
        this.id = String.valueOf(id);
        this.context = context;
    }

    public AbstractMessage(int id, MessageContext context, Map<String, String> tokens) {
        this(id, context);
        this.tokens = tokens;
    }

    public AbstractMessage(int id, MessageContext context, Map<String, String> tokens, String[] params) {
        this(id, context, tokens);
        this.params = params;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Map<String, String> getTokens() {
        return this.tokens;
    }

    @Override
    public MessageContext getContext() {
        return this.context;
    }

    @Override
    public String[] getParams() {
        return this.params;
    }

    public void setTokenMarker(String tokenMarker) {
        this.tokenMarker = tokenMarker;
    }

    @Override
    public void setTokens(Map<String, String> tokens) {
        this.tokens = tokens;
    }

    @Override
    public String getText(Locale loc) {
        String token;
        String regex;
        StringBuilder sb;
        Matcher m;
        String s = this.context.getMessage(this.id, loc);
        if (s == null) {
            return null;
        }
        if (this.params != null && this.params.length > 0) {
            m = PARAM_PATTERN.matcher(s);
            while (m.find()) {
                String index = m.group(1);
                int x = -1;
                try {
                    x = Integer.parseInt(index);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (x < 0 || x >= this.params.length) continue;
                sb = new StringBuilder(16);
                sb.append("\\{").append(x).append("\\}");
                regex = sb.toString();
                s = s.replaceFirst(regex, this.params[x]);
            }
        }
        m = PATTERN.matcher(s);
        while (m.find()) {
            String value;
            token = m.group(1);
            StringTokenizer st = new StringTokenizer(token, ".");
            if (st.countTokens() != 2) continue;
            String listname = st.nextToken();
            String item = st.nextToken();
            ListData list = ListManager.getList(listname);
            if (list == null || (value = list.getValue(item, loc)) == null) continue;
            StringBuilder sb2 = new StringBuilder(16);
            sb2.append("\\").append(LIST_MARKER).append(listname).append("\\.").append(item).append("\\").append(LIST_MARKER);
            String regex2 = sb2.toString();
            s = s.replaceFirst(regex2, value);
        }
        m = I18N_PATTERN.matcher(s);
        while (m.find()) {
            token = m.group(1);
            String value = this.context.getMessage(token, loc);
            if (value == null || value.equals(token)) continue;
            sb = new StringBuilder(16);
            sb.append("\\").append(I18N_MARKER).append(token).append("\\").append(I18N_MARKER);
            regex = sb.toString();
            s = s.replaceFirst(regex, value);
        }
        if (this.tokens != null && !this.tokens.isEmpty()) {
            StringBuffer sb3 = new StringBuffer(s);
            for (String tokenKey : this.tokens.keySet()) {
                String token2 = this.tokens.get(tokenKey);
                StringBuffer t = new StringBuffer(tokenKey.length() + 2);
                t.append(this.tokenMarker).append(tokenKey).append(this.tokenMarker);
                String marker = t.toString();
                int index = sb3.indexOf(marker);
                if (index < 0) continue;
                sb3.replace(index, index + marker.length(), token2);
            }
            return sb3.toString();
        }
        return s;
    }

    public String toString() {
        return this.id;
    }
}

