/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.mail;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.mentawai.core.ApplicationManager;
import org.mentawai.mail.Letter;

public class VelocityLetter
implements Letter {
    public static String CHARSET = "UTF-8";
    private static final String DEF_DIR = "letters";
    private static final String SEP = File.separator;
    private static VelocityEngine ve = null;
    private String filename;
    private VelocityContext vc = new VelocityContext();
    private Map<Locale, Template> cacheBody = new HashMap<Locale, Template>();
    private Map<Locale, String> cacheSubject = new HashMap<Locale, String>();
    private String dir = "letters";

    public VelocityLetter(String filename) {
        if (ve == null) {
            ve = new VelocityEngine();
            Properties p = new Properties();
            p.setProperty("file.resource.loader.path", ApplicationManager.getRealPath());
            p.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogSystem");
            try {
                ve.init(p);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.filename = filename;
    }

    public VelocityLetter(String filename, String dir) throws Exception {
        this(filename);
        this.dir = dir;
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.vc.put(name, value);
    }

    @Override
    public String getText(Locale loc) throws Exception {
        Template t = this.cacheBody.get(loc);
        if (t == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(SEP).append(this.dir).append(SEP);
            if (loc != null) {
                sb.append(loc).append(SEP);
            }
            sb.append(this.filename);
            t = ve.getTemplate(sb.toString(), CHARSET);
            this.cacheBody.put(loc, t);
        }
        StringWriter sw = new StringWriter();
        t.merge((Context)this.vc, (Writer)sw);
        return this.cutFirstLine(sw.toString());
    }

    private String cutFirstLine(String s) {
        int index = s.indexOf(10) + 1;
        if (index < s.length()) {
            return s.substring(index, s.length());
        }
        if (index == s.length()) {
            return " ";
        }
        return s;
    }

    @Override
    public String getText() throws Exception {
        return this.getText(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSubject(Locale loc) throws Exception {
        String s = this.cacheSubject.get(loc);
        if (s == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(ApplicationManager.getRealPath()).append(SEP).append(this.dir).append(SEP);
            if (loc != null) {
                sb.append(loc).append(SEP);
            }
            sb.append(this.filename);
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sb.toString()), CHARSET));
                s = br.readLine();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception e) {}
                }
            }
            this.cacheSubject.put(loc, s);
        }
        return s;
    }

    @Override
    public String getSubject() throws Exception {
        return this.getSubject(null);
    }
}

