/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.mail;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.mentaregex.Regex;
import org.mentawai.core.ApplicationManager;
import org.mentawai.mail.Letter;
import org.mentawai.util.IOUtils;

public class TextLetter
implements Letter {
    public static String CHARSET = "UTF-8";
    private static final String DEF_DIR = "letters";
    private static final String SEP = File.separator;
    private String filename;
    private Map<String, String> props = new HashMap<String, String>();
    private Map<Locale, String> cacheBody = new HashMap<Locale, String>();
    private Map<Locale, String> cacheSubject = new HashMap<Locale, String>();
    private String dir = "letters";

    public TextLetter(String filename) {
        this.filename = filename;
    }

    public TextLetter(String filename, String dir) {
        this(filename);
        this.dir = dir;
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.props.put(name, value.toString());
    }

    @Override
    public String getText(Locale loc) throws Exception {
        String t = this.cacheBody.get(loc);
        if (t == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(ApplicationManager.getRealPath()).append(SEP).append(this.dir).append(SEP);
            if (loc != null) {
                sb.append(loc).append(SEP);
            }
            sb.append(this.filename);
            t = IOUtils.readFile(sb.toString(), CHARSET);
            this.cacheBody.put(loc, t);
        }
        String res = this.merge(t);
        return this.cutFirstLine(res);
    }

    private String merge(String text) {
        String result = new String(text);
        for (String key : this.props.keySet()) {
            String value = this.props.get(key);
            result = Regex.sub(result, "s/#$" + key + "/" + Regex.escapeSlash(value, "#") + "/g", '#');
        }
        return result;
    }

    private String cutFirstLine(String s) {
        int index = s.indexOf(10) + 1;
        if (index < s.length()) {
            return s.substring(index, s.length());
        }
        if (index == s.length()) {
            return " ";
        }
        return s;
    }

    @Override
    public String getText() throws Exception {
        return this.getText(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSubject(Locale loc) throws Exception {
        String s = this.cacheSubject.get(loc);
        if (s == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(ApplicationManager.getRealPath()).append(SEP).append(this.dir).append(SEP);
            if (loc != null) {
                sb.append(loc).append(SEP);
            }
            sb.append(this.filename);
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sb.toString()), CHARSET));
                s = br.readLine();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception e) {}
                }
            }
            this.cacheSubject.put(loc, s);
        }
        return this.merge(s);
    }

    @Override
    public String getSubject() throws Exception {
        return this.getSubject(null);
    }
}

