/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.mail;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.mentawai.mail.Email;
import org.mentawai.mail.EmailAttachment;
import org.mentawai.mail.EmailException;
import org.mentawai.util.StringUtils;

public class MultiPartEmail
extends Email {
    private MimeMultipart container;
    private MimeBodyPart primaryBodyPart;
    private String subType;
    private boolean initialized;
    private boolean boolHasAttachments;

    public void setSubType(String aSubType) {
        this.subType = aSubType;
    }

    public String getSubType() {
        return this.subType;
    }

    public Email addPart(String content, String contentType) throws EmailException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        try {
            bodyPart.setContent((Object)content, contentType);
            this.getContainer().addBodyPart((BodyPart)bodyPart);
        }
        catch (MessagingException me) {
            throw new EmailException(me);
        }
        return this;
    }

    public Email addPart(MimeMultipart multipart) throws EmailException {
        try {
            return this.addPart(multipart, this.getContainer().getCount());
        }
        catch (MessagingException me) {
            throw new EmailException(me);
        }
    }

    public Email addPart(MimeMultipart multipart, int index) throws EmailException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        try {
            bodyPart.setContent((Multipart)multipart);
            this.getContainer().addBodyPart((BodyPart)bodyPart, index);
        }
        catch (MessagingException me) {
            throw new EmailException(me);
        }
        return this;
    }

    protected void init() {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        this.container = new MimeMultipart();
        super.setContent(this.container);
        this.initialized = true;
    }

    @Override
    public Email setMsg(String msg) throws EmailException {
        if (StringUtils.isEmpty(msg)) {
            throw new EmailException("The message cannot be empty.");
        }
        try {
            if (StringUtils.isNotEmpty(this.charset)) {
                this.getPrimaryBodyPart().setText(msg, this.charset);
            } else {
                this.getPrimaryBodyPart().setText(msg);
            }
        }
        catch (MessagingException me) {
            throw new EmailException(me);
        }
        return this;
    }

    @Override
    public void send() throws EmailException {
        try {
            if (this.primaryBodyPart != null) {
                MimeBodyPart body = this.getPrimaryBodyPart();
                try {
                    body.getContent();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.subType != null) {
                this.getContainer().setSubType(this.subType);
            }
            super.send();
        }
        catch (MessagingException me) {
            throw new EmailException(me);
        }
    }

    public MultiPartEmail attach(EmailAttachment attachment) throws EmailException {
        MultiPartEmail result = null;
        if (attachment == null) {
            throw new EmailException("Invalid attachment supplied");
        }
        URL url = attachment.getURL();
        if (url == null) {
            String fileName = null;
            try {
                fileName = attachment.getPath();
                File file = new File(fileName);
                if (!file.exists()) {
                    throw new IOException("\"" + fileName + "\" does not exist");
                }
                result = this.attach((DataSource)new FileDataSource(file), attachment.getName(), attachment.getDescription(), attachment.getDisposition());
            }
            catch (Exception e) {
                throw new EmailException("Cannot attach file \"" + fileName + "\"", e);
            }
        } else {
            result = this.attach(url, attachment.getName(), attachment.getDescription(), attachment.getDisposition());
        }
        return result;
    }

    public MultiPartEmail attach(URL url, String name, String description) throws EmailException {
        return this.attach(url, name, description, "attachment");
    }

    public MultiPartEmail attach(URL url, String name, String description, String disposition) throws EmailException {
        try {
            InputStream is = url.openStream();
            is.close();
        }
        catch (IOException e) {
            throw new EmailException("Invalid URL set");
        }
        return this.attach((DataSource)new URLDataSource(url), name, description, disposition);
    }

    public MultiPartEmail attach(DataSource ds, String name, String description) throws EmailException {
        try {
            if (ds == null || ds.getInputStream() == null) {
                throw new EmailException("Invalid Datasource");
            }
        }
        catch (IOException e) {
            throw new EmailException("Invalid Datasource");
        }
        return this.attach(ds, name, description, "attachment");
    }

    public MultiPartEmail attach(DataSource ds, String name, String description, String disposition) throws EmailException {
        if (StringUtils.isEmpty(name)) {
            name = ds.getName();
        }
        MimeBodyPart mbp = new MimeBodyPart();
        try {
            this.getContainer().addBodyPart((BodyPart)mbp);
            mbp.setDisposition(disposition);
            mbp.setFileName(name);
            mbp.setDescription(description);
            mbp.setDataHandler(new DataHandler(ds));
        }
        catch (MessagingException me) {
            throw new EmailException(me);
        }
        this.boolHasAttachments = true;
        return this;
    }

    protected MimeBodyPart getPrimaryBodyPart() throws MessagingException {
        if (!this.initialized) {
            this.init();
        }
        if (this.primaryBodyPart == null) {
            this.primaryBodyPart = new MimeBodyPart();
            this.getContainer().addBodyPart((BodyPart)this.primaryBodyPart, 0);
        }
        return this.primaryBodyPart;
    }

    protected MimeMultipart getContainer() {
        if (!this.initialized) {
            this.init();
        }
        return this.container;
    }

    public boolean isBoolHasAttachments() {
        return this.boolHasAttachments;
    }

    public void setBoolHasAttachments(boolean b) {
        this.boolHasAttachments = b;
    }
}

