/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.mail;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.mentawai.mail.Email;
import org.mentawai.mail.EmailException;
import org.mentawai.mail.MultiPartEmail;
import org.mentawai.mail.RandomStringUtils;
import org.mentawai.util.StringUtils;

public class HtmlEmail
extends MultiPartEmail {
    public static final int CID_LENGTH = 10;
    protected String text;
    protected String html;
    protected List<MimeBodyPart> inlineImages = new ArrayList<MimeBodyPart>();

    public List<InternetAddress> getToList() {
        return new ArrayList<InternetAddress>(this.toList);
    }

    public List<InternetAddress> getCcList() {
        return new ArrayList<InternetAddress>(this.ccList);
    }

    public List<InternetAddress> getBccList() {
        return new ArrayList<InternetAddress>(this.bccList);
    }

    public List<InternetAddress> getReplyList() {
        return new ArrayList<InternetAddress>(this.replyList);
    }

    public HtmlEmail setTextMsg(String aText) throws EmailException {
        if (StringUtils.isEmpty(aText)) {
            throw new EmailException("The message cannot be empty.");
        }
        this.text = aText;
        return this;
    }

    public HtmlEmail setHtmlMsg(String aHtml) throws EmailException {
        if (StringUtils.isEmpty(aHtml)) {
            throw new EmailException("The message cannot be empty.");
        }
        this.html = aHtml;
        return this;
    }

    @Override
    public Email setMsg(String msg) throws EmailException {
        if (StringUtils.isEmpty(msg)) {
            throw new EmailException("The message cannot be empty.");
        }
        this.setTextMsg(msg);
        this.setHtmlMsg(new StringBuffer().append("<html><body><pre>").append(msg).append("</pre></body></html>").toString());
        return this;
    }

    public String embed(URL url, String name) throws EmailException {
        try {
            InputStream is = url.openStream();
            is.close();
        }
        catch (IOException e) {
            throw new EmailException("Invalid URL");
        }
        MimeBodyPart mbp = new MimeBodyPart();
        try {
            mbp.setDataHandler(new DataHandler((DataSource)new URLDataSource(url)));
            mbp.setFileName(name);
            mbp.setDisposition("inline");
            String cid = RandomStringUtils.randomAlphabetic(10).toLowerCase();
            mbp.addHeader("Content-ID", "<" + cid + ">");
            this.inlineImages.add(mbp);
            return cid;
        }
        catch (MessagingException me) {
            throw new EmailException(me);
        }
    }

    @Override
    public void send() throws EmailException {
        try {
            if (this.isBoolHasAttachments()) {
                this.buildAttachments();
            } else {
                this.buildNoAttachments();
            }
        }
        catch (MessagingException me) {
            throw new EmailException(me);
        }
        super.send();
    }

    private void buildAttachments() throws MessagingException, EmailException {
        MimeMultipart container = this.getContainer();
        MimeMultipart subContainer = null;
        MimeMultipart subContainerHTML = new MimeMultipart("related");
        MimeBodyPart msgHtml = null;
        MimeBodyPart msgText = null;
        container.setSubType("mixed");
        subContainer = new MimeMultipart("alternative");
        if (StringUtils.isNotEmpty(this.text)) {
            msgText = new MimeBodyPart();
            subContainer.addBodyPart((BodyPart)msgText);
            if (StringUtils.isNotEmpty(this.charset)) {
                msgText.setContent((Object)this.text, "text/plain; charset=" + this.charset);
            } else {
                msgText.setContent((Object)this.text, "text/plain");
            }
        }
        if (StringUtils.isNotEmpty(this.html)) {
            if (this.inlineImages.size() > 0) {
                msgHtml = new MimeBodyPart();
                subContainerHTML.addBodyPart((BodyPart)msgHtml);
            } else {
                msgHtml = new MimeBodyPart();
                subContainer.addBodyPart((BodyPart)msgHtml);
            }
            if (StringUtils.isNotEmpty(this.charset)) {
                msgHtml.setContent((Object)this.html, "text/html; charset=" + this.charset);
            } else {
                msgHtml.setContent((Object)this.html, "text/html");
            }
            Iterator<MimeBodyPart> iter = this.inlineImages.iterator();
            while (iter.hasNext()) {
                subContainerHTML.addBodyPart((BodyPart)iter.next());
            }
        }
        this.addPart(subContainer, 0);
        if (this.inlineImages.size() > 0) {
            this.addPart(subContainerHTML, 1);
        }
    }

    private void buildNoAttachments() throws MessagingException, EmailException {
        MimeMultipart container = this.getContainer();
        MimeMultipart subContainerHTML = new MimeMultipart("related");
        container.setSubType("alternative");
        MimeBodyPart msgText = null;
        MimeBodyPart msgHtml = null;
        if (StringUtils.isNotEmpty(this.text)) {
            msgText = this.getPrimaryBodyPart();
            if (StringUtils.isNotEmpty(this.charset)) {
                msgText.setContent((Object)this.text, "text/plain; charset=" + this.charset);
            } else {
                msgText.setContent((Object)this.text, "text/plain");
            }
        }
        if (StringUtils.isNotEmpty(this.html)) {
            if (msgText == null) {
                msgHtml = this.getPrimaryBodyPart();
            } else if (this.inlineImages.size() > 0) {
                msgHtml = new MimeBodyPart();
                subContainerHTML.addBodyPart((BodyPart)msgHtml);
            } else {
                msgHtml = new MimeBodyPart();
                container.addBodyPart((BodyPart)msgHtml, 1);
            }
            if (StringUtils.isNotEmpty(this.charset)) {
                msgHtml.setContent((Object)this.html, "text/html; charset=" + this.charset);
            } else {
                msgHtml.setContent((Object)this.html, "text/html");
            }
            Iterator<MimeBodyPart> iter = this.inlineImages.iterator();
            while (iter.hasNext()) {
                subContainerHTML.addBodyPart((BodyPart)iter.next());
            }
            if (this.inlineImages.size() > 0) {
                this.addPart(subContainerHTML);
            }
        }
    }
}

