/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.mail;

import java.security.AccessControlException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.mentaregex.Regex;
import org.mentawai.mail.DefaultAuthenticator;
import org.mentawai.mail.EmailException;
import org.mentawai.util.StringUtils;

public abstract class Email {
    public static final String SENDER_EMAIL = "sender.email";
    public static final String SENDER_NAME = "sender.name";
    public static final String RECEIVER_EMAIL = "receiver.email";
    public static final String RECEIVER_NAME = "receiver.name";
    public static final String EMAIL_SUBJECT = "email.subject";
    public static final String EMAIL_BODY = "email.body";
    public static final String CONTENT_TYPE = "content.type";
    public static final String MAIL_HOST = "mail.host";
    public static final String MAIL_PORT = "mail.smtp.port";
    public static final String MAIL_SMTP_FROM = "mail.smtp.from";
    public static final String MAIL_SMTP_AUTH = "mail.smtp.auth";
    public static final String MAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    public static final String SMTP = "smtp";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String ATTACHMENTS = "attachments";
    public static final String FILE_SERVER = "file.server";
    public static final String MAIL_DEBUG = "mail.debug";
    public static final String KOI8_R = "koi8-r";
    public static final String ISO_8859_1 = "iso-8859-1";
    public static final String US_ASCII = "us-ascii";
    protected MimeMessage message;
    protected String charset;
    protected InternetAddress fromAddress;
    protected String subject;
    protected MimeMultipart emailBody;
    protected Object content;
    protected String contentType;
    protected boolean debug;
    protected Date sentDate;
    protected Authenticator authenticator;
    protected String hostName;
    protected String smtpPort = "25";
    protected boolean ssl_connection = false;
    protected List<InternetAddress> toList = new ArrayList<InternetAddress>();
    protected List<InternetAddress> ccList = new ArrayList<InternetAddress>();
    protected List<InternetAddress> bccList = new ArrayList<InternetAddress>();
    protected List<InternetAddress> replyList = new ArrayList<InternetAddress>();
    protected String bounceAddress;
    protected Map<String, String> headers = new HashMap<String, String>();
    protected boolean popBeforeSmtp;
    protected String popHost;
    protected String popUsername;
    protected String popPassword;
    private Session session;
    private static String def_username = null;
    private static String def_password = null;
    private static String def_hostname = "localhost";
    private static String def_bounce_email = null;
    private static InternetAddress def_from = null;
    private static String def_charset = "UTF-8";
    private static boolean send_email = true;
    private static final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
    public static final String MAIL_FACTORY_PORT = "mail.smtp.socketFactory.port";
    public static final String MAIL_FACTORY_CLASS = "mail.smtp.socketFactory.class";
    public static final String MAIL_FACTORY_FALLBACK = "mail.smtp.socketFactory.fallback";
    private static String factory_fallback = "false";
    private static String def_port = null;
    private static boolean def_ssl_connection = false;

    public static void setSendEmail(boolean sendEmail) {
        send_email = sendEmail;
    }

    public static void setDefaultCharset(String charset) {
        def_charset = charset;
    }

    public static void setDefaultAuthentication(String user, String pass) {
        def_username = user;
        def_password = pass;
    }

    public static void setDefaultHostName(String host) {
        def_hostname = host;
    }

    public static void setDefaultFrom(String email, String name) {
        try {
            def_from = Email.createInternetAddress(email, name, def_charset);
        }
        catch (EmailException e) {
            e.printStackTrace();
        }
    }

    public static void setDefaultBounceAddress(String email) {
        def_bounce_email = email;
    }

    public static void setDefaultPort(int port) {
        def_port = String.valueOf(port);
    }

    public static void setDefaultPort(String port) {
        def_port = port;
    }

    public static void setDefaultSslConnection(boolean active) {
        def_ssl_connection = active;
    }

    public static void setSSLConnection(boolean active) {
        Email.setDefaultSslConnection(active);
    }

    public static void setFactoryFallBack(String active) {
        factory_fallback = active;
    }

    public Email() {
        if (def_charset != null) {
            this.setCharset(def_charset);
        }
        if (def_username != null && def_password != null) {
            this.setAuthentication(def_username, def_password);
        }
        if (def_hostname != null) {
            this.setHostName(def_hostname);
        }
        if (def_from != null) {
            this.fromAddress = def_from;
        }
        if (def_bounce_email != null) {
            this.setBounceAddress(def_bounce_email);
        }
        if (def_port != null) {
            this.setSmtpPort(Integer.parseInt(def_port));
        }
        if (def_ssl_connection) {
            this.setSslConnection(true);
        }
    }

    public void setSslConnection(boolean flag) {
        this.ssl_connection = flag;
    }

    public void setDebug(boolean d) {
        this.debug = d;
    }

    public void setAuthentication(String userName, String password) {
        this.authenticator = new DefaultAuthenticator(userName, password);
        this.setAuthenticator(this.authenticator);
    }

    public void setAuthenticator(Authenticator newAuthenticator) {
        this.authenticator = newAuthenticator;
    }

    public void setCharset(String newCharset) {
        this.charset = newCharset;
    }

    public void setContent(MimeMultipart aMimeMultipart) {
        this.emailBody = aMimeMultipart;
    }

    public void setContent(Object aObject, String aContentType) {
        this.content = aObject;
        if (!StringUtils.isNotEmpty(aContentType)) {
            this.contentType = null;
        } else {
            this.contentType = aContentType;
            String strMarker = "; charset=";
            int charsetPos = aContentType.toLowerCase().indexOf(strMarker);
            if (charsetPos != -1) {
                int intCharsetEnd = aContentType.toLowerCase().indexOf(" ", charsetPos += strMarker.length());
                this.charset = intCharsetEnd != -1 ? aContentType.substring(charsetPos, intCharsetEnd) : aContentType.substring(charsetPos);
            } else if (this.contentType.startsWith("text/") && StringUtils.isNotEmpty(this.charset)) {
                StringBuffer contentTypeBuf = new StringBuffer(this.contentType);
                contentTypeBuf.append(strMarker);
                contentTypeBuf.append(this.charset);
                this.contentType = contentTypeBuf.toString();
            }
        }
    }

    public void setHostName(String aHostName) {
        this.hostName = aHostName;
    }

    public void setSmtpPort(int aPortNumber) {
        if (aPortNumber < 1) {
            throw new IllegalArgumentException("Cannot connect to a port number that is less than 1 ( " + aPortNumber + " )");
        }
        this.smtpPort = Integer.toString(aPortNumber);
    }

    public void setMailSession(Session aSession) {
        this.session = aSession;
    }

    protected Session getMailSession() throws EmailException {
        if (this.session == null) {
            Properties properties = new Properties();
            try {
                properties = new Properties(System.getProperties());
                properties.setProperty(MAIL_TRANSPORT_PROTOCOL, SMTP);
                if (!StringUtils.isNotEmpty(this.hostName)) {
                    this.hostName = properties.getProperty(MAIL_HOST);
                }
                if (!StringUtils.isNotEmpty(this.hostName)) {
                    throw new EmailException("Cannot find valid hostname for mail session");
                }
                properties.setProperty(MAIL_PORT, this.smtpPort);
                properties.setProperty(MAIL_HOST, this.hostName);
                properties.setProperty(MAIL_DEBUG, String.valueOf(this.debug));
                if (this.authenticator != null) {
                    properties.setProperty(MAIL_SMTP_AUTH, "true");
                }
                if (this.ssl_connection) {
                    properties.setProperty(MAIL_FACTORY_PORT, this.smtpPort);
                    properties.setProperty(MAIL_FACTORY_CLASS, SSL_FACTORY);
                    properties.setProperty(MAIL_FACTORY_FALLBACK, factory_fallback);
                }
                if (this.bounceAddress != null) {
                    properties.setProperty(MAIL_SMTP_FROM, this.bounceAddress);
                }
            }
            catch (AccessControlException e) {
                e.printStackTrace();
            }
            this.session = Session.getInstance((Properties)properties, (Authenticator)this.authenticator);
        }
        return this.session;
    }

    private static InternetAddress createInternetAddress(String email, String name, String charset) throws EmailException {
        InternetAddress address = null;
        try {
            if (!StringUtils.isNotEmpty(name)) {
                name = email;
            }
            address = StringUtils.isNotEmpty(charset) ? new InternetAddress(email, name, charset) : new InternetAddress(email, name);
            address.validate();
        }
        catch (Exception e) {
            throw new EmailException(e);
        }
        return address;
    }

    public Email setFrom(String email) throws EmailException {
        return this.setFrom(email, null);
    }

    public Email setFrom(String email, String name) throws EmailException {
        this.fromAddress = Email.createInternetAddress(email, name, this.charset);
        return this;
    }

    public Email addTo(String email) throws EmailException {
        return this.addTo(email, null);
    }

    public Email addTo(String email, String name) throws EmailException {
        this.toList.add(Email.createInternetAddress(email, name, this.charset));
        return this;
    }

    public void removeTo(String email) {
        Email.removeEmail(email, this.toList);
    }

    public Email setTo(Collection aCollection) throws EmailException {
        if (aCollection == null || aCollection.isEmpty()) {
            throw new EmailException("Address List provided was invalid");
        }
        this.toList = new ArrayList<InternetAddress>(aCollection);
        return this;
    }

    public Email addCc(String email) throws EmailException {
        return this.addCc(email, null);
    }

    public Email addCc(String email, String name) throws EmailException {
        this.ccList.add(Email.createInternetAddress(email, name, this.charset));
        return this;
    }

    public Email setCc(Collection aCollection) throws EmailException {
        if (aCollection == null || aCollection.isEmpty()) {
            throw new EmailException("Address List provided was invalid");
        }
        this.ccList = new ArrayList<InternetAddress>(aCollection);
        return this;
    }

    public void removeCc(String email) {
        Email.removeEmail(email, this.ccList);
    }

    public Email addBcc(String email) throws EmailException {
        return this.addBcc(email, null);
    }

    public Email addBcc(String email, String name) throws EmailException {
        this.bccList.add(Email.createInternetAddress(email, name, this.charset));
        return this;
    }

    public void removeBcc(String email) {
        Email.removeEmail(email, this.bccList);
    }

    private static void removeEmail(String email, List<InternetAddress> list) {
        Iterator<InternetAddress> iter = list.iterator();
        while (iter.hasNext()) {
            InternetAddress ia = iter.next();
            if (!ia.getAddress().equals(email)) continue;
            iter.remove();
        }
    }

    public Email setBcc(Collection aCollection) throws EmailException {
        if (aCollection == null || aCollection.isEmpty()) {
            throw new EmailException("Address List provided was invalid");
        }
        this.bccList = new ArrayList<InternetAddress>(aCollection);
        return this;
    }

    public Email addReplyTo(String email) throws EmailException {
        return this.addReplyTo(email, null);
    }

    public Email addReplyTo(String email, String name) throws EmailException {
        this.replyList.add(Email.createInternetAddress(email, name, this.charset));
        return this;
    }

    public void setHeaders(Map<String, String> map) {
        for (String strName : map.keySet()) {
            String strValue = map.get(strName);
            if (!StringUtils.isNotEmpty(strName)) {
                throw new IllegalArgumentException("name can not be null");
            }
            if (StringUtils.isNotEmpty(strValue)) continue;
            throw new IllegalArgumentException("value can not be null");
        }
        this.headers = map;
    }

    public void addHeader(String name, String value) {
        if (!StringUtils.isNotEmpty(name)) {
            throw new IllegalArgumentException("name can not be null");
        }
        if (!StringUtils.isNotEmpty(value)) {
            throw new IllegalArgumentException("value can not be null");
        }
        this.headers.put(name, value);
    }

    public Email setSubject(String aSubject) {
        this.subject = aSubject;
        return this;
    }

    public Email setBounceAddress(String email) {
        this.bounceAddress = email;
        return this;
    }

    public abstract Email setMsg(String var1) throws EmailException;

    public void sendLater() {
        this.sendLater(true, false);
    }

    public void sendLater(boolean recoverFromBadEmails) {
        this.sendLater(true, recoverFromBadEmails);
    }

    public void sendLater(final boolean printException, final boolean recoverFromBadEmails) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                block8: {
                    try {
                        Email.this.send();
                    }
                    catch (Exception e) {
                        block7: {
                            String msg;
                            String[] emails;
                            if (recoverFromBadEmails && e instanceof EmailException && (emails = Regex.match(msg = e.getMessage(), "/ #<(.+@.+)#>#:/g", '#')) != null && emails.length > 0) {
                                for (String email : emails) {
                                    Email.this.removeTo(email);
                                    Email.this.removeCc(email);
                                    Email.this.removeBcc(email);
                                }
                                if (!Email.this.toList.isEmpty()) {
                                    try {
                                        Email.this.send();
                                        return;
                                    }
                                    catch (Exception exc) {
                                        if (!printException) break block7;
                                        System.err.println("Could not recover from bad emails: " + exc);
                                    }
                                }
                            }
                        }
                        if (!printException) break block8;
                        System.err.println("Erro sending email: " + e);
                    }
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public void send() throws EmailException {
        this.send(false);
    }

    public void send(boolean recoverFromBadEmails) throws EmailException {
        if (!send_email) {
            return;
        }
        try {
            this.getMailSession();
            this.message = new MimeMessage(this.session);
            if (StringUtils.isNotEmpty(this.subject)) {
                if (StringUtils.isNotEmpty(this.charset)) {
                    this.message.setSubject(this.subject, this.charset);
                } else {
                    this.message.setSubject(this.subject);
                }
            }
            if (this.content != null) {
                this.message.setContent(this.content, this.contentType);
            } else if (this.emailBody != null) {
                this.message.setContent((Multipart)this.emailBody);
            } else {
                this.message.setContent((Object)"", TEXT_PLAIN);
            }
            if (this.fromAddress == null) {
                throw new EmailException("Sender address required");
            }
            this.message.setFrom((Address)this.fromAddress);
            if (this.toList.size() + this.ccList.size() + this.bccList.size() == 0) {
                throw new EmailException("At least one receiver address required");
            }
            if (this.toList.size() > 0) {
                this.message.setRecipients(Message.RecipientType.TO, (Address[])this.toInternetAddressArray(this.toList));
            }
            if (this.ccList.size() > 0) {
                this.message.setRecipients(Message.RecipientType.CC, (Address[])this.toInternetAddressArray(this.ccList));
            }
            if (this.bccList.size() > 0) {
                this.message.setRecipients(Message.RecipientType.BCC, (Address[])this.toInternetAddressArray(this.bccList));
            }
            if (this.replyList.size() > 0) {
                this.message.setReplyTo((Address[])this.toInternetAddressArray(this.replyList));
            }
            if (this.headers.size() > 0) {
                for (String name : this.headers.keySet()) {
                    String value = this.headers.get(name);
                    this.message.addHeader(name, value);
                }
            }
            if (this.message.getSentDate() == null) {
                this.message.setSentDate(this.getSentDate());
            }
            if (this.popBeforeSmtp) {
                Store store = this.session.getStore("pop3");
                store.connect(this.popHost, this.popUsername, this.popPassword);
            }
            Transport.send((Message)this.message);
        }
        catch (MessagingException me) {
            String msg;
            String[] emails;
            if (recoverFromBadEmails && me instanceof SendFailedException && (emails = Regex.match(msg = me.getMessage(), "/ #<(.+@.+)#>#:/g", '#')) != null && emails.length > 0) {
                for (String email : emails) {
                    this.removeTo(email);
                    this.removeCc(email);
                    this.removeBcc(email);
                }
                if (!this.toList.isEmpty()) {
                    try {
                        this.send();
                        return;
                    }
                    catch (Exception exc) {
                        throw new EmailException(exc);
                    }
                }
            }
            throw new EmailException(me);
        }
    }

    public void setSentDate(Date date) {
        this.sentDate = date;
    }

    public Date getSentDate() {
        if (this.sentDate == null) {
            return new Date();
        }
        return this.sentDate;
    }

    protected InternetAddress[] toInternetAddressArray(List<InternetAddress> list) {
        InternetAddress[] ia = list.toArray(new InternetAddress[0]);
        return ia;
    }

    public void setPopBeforeSmtp(boolean newPopBeforeSmtp, String newPopHost, String newPopUsername, String newPopPassword) {
        this.popBeforeSmtp = newPopBeforeSmtp;
        this.popHost = newPopHost;
        this.popUsername = newPopUsername;
        this.popPassword = newPopPassword;
    }

    static {
        try {
            String klass = "com.sun.net.ssl.internal.ssl.Provider";
            Security.addProvider((Provider)Class.forName(klass).newInstance());
        }
        catch (Throwable t) {
            System.err.println("Could not set SSL for email! Email will not support SSL connections!");
            System.out.println(t);
        }
    }
}

