/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.mentawai.log.Logger;

public class SimpleLogger
implements Logger {
    private PrintWriter out;
    private final Format header = this.getHeaderFormat();
    private final Format rollFile = this.getRollFileFormat();
    private final MutableLong myLong = new MutableLong();
    private boolean enable = false;
    private File outputFile = null;
    private boolean alsoSystemOut = false;
    private String levelString = null;

    public SimpleLogger(PrintWriter out) {
        this.out = out;
        this.printTopHeader();
    }

    public SimpleLogger(String filename) throws IOException {
        this.outputFile = new File(filename);
        FileOutputStream fos = new FileOutputStream(this.outputFile, true);
        this.out = new PrintWriter((Writer)new OutputStreamWriter(fos), false);
        this.printTopHeader();
    }

    public SimpleLogger(String dir, String filename) throws IOException {
        if (!dir.endsWith("/") && !filename.startsWith("/")) {
            dir = dir + "/";
        }
        this.outputFile = new File(dir + filename);
        FileOutputStream fos = new FileOutputStream(this.outputFile, true);
        this.out = new PrintWriter((Writer)new OutputStreamWriter(fos), false);
        this.printTopHeader();
    }

    public SimpleLogger(File file) throws IOException {
        this.outputFile = file;
        FileOutputStream fos = new FileOutputStream(this.outputFile, true);
        this.out = new PrintWriter((Writer)new OutputStreamWriter(fos), false);
        this.printTopHeader();
    }

    public SimpleLogger(PrintStream stream) {
        this.out = new PrintWriter((Writer)new OutputStreamWriter(stream), true);
    }

    public void setAlsoSystemOut(boolean flag, String levelString) {
        this.alsoSystemOut = flag;
        this.levelString = levelString;
    }

    @Override
    public synchronized void roll() throws IOException {
        if (this.outputFile == null || !this.outputFile.exists()) {
            return;
        }
        this.out.close();
        String file = this.outputFile.getAbsoluteFile() + this.rollFile.format(new Long(System.currentTimeMillis()));
        this.outputFile.renameTo(new File(file));
        this.out = new PrintWriter((Writer)new FileWriter(this.outputFile), false);
        this.printTopHeader();
    }

    @Override
    public void enable(boolean flag) {
        this.enable = flag;
    }

    protected void printTopHeader() {
        this.out.println("LOG OPENED - " + new Date().toString());
    }

    protected Format getRollFileFormat() {
        return new SimpleDateFormat("-dd/MM/yyyy-HH:mm:ss");
    }

    protected Format getHeaderFormat() {
        return new SimpleDateFormat("dd.HH:mm:ss");
    }

    protected synchronized void header() {
        this.myLong.setValue(System.currentTimeMillis());
        String h = this.header.format(this.myLong);
        this.out.print(h);
        this.out.print(' ');
        if (this.alsoSystemOut) {
            System.out.print(this.levelString);
            System.out.print(" - ");
            System.out.print(h);
            System.out.print(' ');
        }
    }

    @Override
    public synchronized void log(String ... msgs) {
        if (!this.enable) {
            return;
        }
        this.header();
        int count = 0;
        for (String msg : msgs) {
            if (count++ > 0) {
                this.out.print(' ');
                if (this.alsoSystemOut) {
                    System.out.print(' ');
                }
            }
            this.out.print((Object)msg);
            if (!this.alsoSystemOut) continue;
            System.out.print((Object)msg);
        }
        this.out.println();
        this.out.flush();
        if (this.alsoSystemOut) {
            System.out.println();
            System.out.flush();
        }
    }

    @Override
    public synchronized void log(Object ... objects) {
        if (!this.enable) {
            return;
        }
        this.header();
        int count = 0;
        for (Object object : objects) {
            if (count++ > 0) {
                this.out.print(' ');
                if (this.alsoSystemOut) {
                    System.out.print(' ');
                }
            }
            this.out.print(object);
            if (!this.alsoSystemOut) continue;
            System.out.print(object);
        }
        this.out.println();
        this.out.flush();
        if (this.alsoSystemOut) {
            System.out.println();
            System.out.flush();
        }
    }

    private static class MutableLong
    extends Number {
        private long value;

        private MutableLong() {
        }

        public void setValue(long value) {
            this.value = value;
        }

        @Override
        public int intValue() {
            if (this.value <= Integer.MAX_VALUE) {
                return (int)this.value;
            }
            throw new IllegalStateException("Number is too big to be returned as Integer: " + this.value);
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }
    }
}

