/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.log;

import java.io.File;
import java.io.IOException;
import org.mentawai.core.ApplicationManager;
import org.mentawai.log.Logger;
import org.mentawai.log.SimpleLogger;

public class Debug {
    private static boolean ENABLED = false;
    public static String FILENAME = "DEBUG.LOG";
    private static Logger logger;

    public static void enable(boolean flag) {
        if (logger != null) {
            logger.enable(flag);
            ENABLED = flag;
        }
    }

    public static boolean isEnabled() {
        return ENABLED;
    }

    public static void roll() throws IOException {
        if (logger != null) {
            logger.roll();
        }
    }

    public static void log(String ... msgs) {
        if (logger != null) {
            logger.log(msgs);
        }
    }

    public static void log(Object ... objects) {
        if (logger != null) {
            logger.log(objects);
        }
    }

    public static void setLogger(Logger logger) {
        Debug.logger = logger;
    }

    static {
        try {
            boolean isConsole = Boolean.getBoolean("logConsole");
            if (isConsole) {
                logger = new SimpleLogger(System.out);
            } else {
                String filename = System.getProperty("logDebugFile", FILENAME);
                String dir = System.getProperty("logDir");
                if (dir == null) {
                    File theDir;
                    dir = ApplicationManager.getRealPath();
                    if (!dir.endsWith("/")) {
                        dir = dir + "/";
                    }
                    if (!(theDir = new File(dir = dir + "WEB-INF/logs")).exists()) {
                        theDir.mkdir();
                    }
                }
                SimpleLogger sl = new SimpleLogger(dir, filename);
                boolean noSystemOut = Boolean.getBoolean("noSystemOut");
                if (!noSystemOut) {
                    sl.setAlsoSystemOut(true, "DEBUG");
                }
                logger = sl;
            }
            Debug.enable(false);
        }
        catch (Exception e) {
            System.err.println("Cannot open " + FILENAME + "!!!");
            e.printStackTrace();
            logger = null;
        }
    }
}

