/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.list;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.mentawai.list.ListData;
import org.mentawai.list.ListDataItem;
import org.mentawai.list.ListItem;

public class SimpleListData
implements ListData {
    private List<ListItem> list = new LinkedList<ListItem>();
    private Map<String, String> map = new HashMap<String, String>();
    private String name;

    public SimpleListData() {
        this("");
    }

    public SimpleListData(String name) {
        this.name = name;
    }

    public void clear() {
        this.list.clear();
        this.map.clear();
    }

    public void add(int id, String msg) {
        this.add(String.valueOf(id), msg);
    }

    public void add(String id, String msg) {
        if (!this.map.containsKey(id)) {
            this.map.put(id, msg);
            this.list.add(new ListDataItem(id, msg));
        }
    }

    public void add(Enum e, String msg) {
        this.add(e.toString(), msg);
    }

    @Override
    public String getValue(String id) {
        return this.getValue(id, null);
    }

    @Override
    public String getValue(int id) {
        return this.getValue(String.valueOf(id), null);
    }

    @Override
    public String getValue(String id, Locale loc) {
        return this.map.get(id);
    }

    @Override
    public String getValue(int id, Locale loc) {
        return this.getValue(String.valueOf(id), loc);
    }

    @Override
    public List<ListItem> getValues() {
        return this.getValues(null);
    }

    @Override
    public List<ListItem> getValues(Locale loc) {
        return this.list;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    public String toString() {
        if (this.list.isEmpty()) {
            return "{}";
        }
        Iterator<ListItem> i = this.list.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (i.hasNext()) {
            ListItem item = i.next();
            sb.append(item.getKey());
            sb.append('=');
            sb.append(item.getValue());
            if (!i.hasNext()) continue;
            sb.append(',').append('\n');
        }
        sb.append('}');
        return sb.toString();
    }

    public static ListData getDaysOfTheMonth(String name) {
        SimpleListData list = new SimpleListData(name);
        for (int i = 1; i <= 31; ++i) {
            list.add(i, String.valueOf(i));
        }
        return list;
    }

    public static ListData getYears(String name, int begin, int end) {
        SimpleListData list = new SimpleListData(name);
        while (begin <= end) {
            list.add(String.valueOf(begin), String.valueOf(begin));
            ++begin;
        }
        return list;
    }
}

