/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.mentawai.i18n.LocaleManager;
import org.mentawai.list.ListData;
import org.mentawai.list.ListDataItem;
import org.mentawai.list.ListItem;

public class LocalizedListData
implements ListData {
    private Map<Locale, List<ListItem>> lists = new HashMap<Locale, List<ListItem>>();
    private Map<Locale, Map<String, ListItem>> items = new HashMap<Locale, Map<String, ListItem>>();
    private String name;

    public LocalizedListData(String name) {
        this.name = name;
    }

    public void clear() {
        this.lists.clear();
        this.items.clear();
    }

    public void add(int id, String value, Locale loc) {
        this.add(String.valueOf(id), value, loc);
    }

    public void add(String id, String value, Locale loc) {
        Map<String, ListItem> map;
        List<ListItem> list = this.lists.get(loc);
        if (list == null) {
            list = new LinkedList<ListItem>();
            this.lists.put(loc, list);
        }
        if ((map = this.items.get(loc)) == null) {
            map = new HashMap<String, ListItem>();
            this.items.put(loc, map);
        }
        ListDataItem item = new ListDataItem(id, value);
        list.add(item);
        map.put(item.getKey(), item);
    }

    @Override
    public String getValue(int id, Locale loc) {
        return this.getValue(String.valueOf(id), loc);
    }

    private Locale getAnyLocale() {
        if (this.items.isEmpty()) {
            return null;
        }
        return this.items.keySet().iterator().next();
    }

    @Override
    public String getValue(String id) {
        String value = this.getValue(id, LocaleManager.getDefaultLocale());
        if (value == null) {
            Locale loc = this.getAnyLocale();
            if (loc == null) {
                return null;
            }
            return this.getValue(id, loc);
        }
        return value;
    }

    @Override
    public String getValue(int id) {
        return this.getValue(String.valueOf(id));
    }

    @Override
    public String getValue(String id, Locale loc) {
        Map<String, ListItem> map = this.items.get(loc);
        if (map == null || !map.containsKey(id)) {
            return null;
        }
        ListItem item = map.get(id);
        return item.getValue();
    }

    @Override
    public List<ListItem> getValues(Locale loc) {
        Locale l;
        List<ListItem> list = this.lists.get(loc);
        if (list == null) {
            list = this.lists.get(LocaleManager.getDefaultLocale());
        }
        if (list == null && (l = this.getAnyLocale()) != null) {
            list = this.lists.get(l);
        }
        if (list == null) {
            list = new ArrayList<ListItem>(0);
        }
        return list;
    }

    @Override
    public List<ListItem> getValues() {
        return this.getValues(LocaleManager.getDefaultLocale());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int size() {
        Iterator<List<ListItem>> iter = this.lists.values().iterator();
        if (!iter.hasNext()) {
            return 0;
        }
        List<ListItem> list = iter.next();
        return list.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("LocalizedListData: name=").append(this.name).append(" size=").append(this.size());
        return sb.toString();
    }
}

