/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.list;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.mentawai.core.ApplicationManager;
import org.mentawai.db.ConnectionHandler;
import org.mentawai.i18n.LocaleManager;
import org.mentawai.list.BaseListData;
import org.mentawai.list.DBListData;
import org.mentawai.list.I18nListData;
import org.mentawai.list.ListData;
import org.mentawai.list.ListItem;
import org.mentawai.list.SimpleListData;
import org.mentawai.util.InjectionUtils;

public class ListManager {
    private static final String SEP = File.separator;
    public static String LIST_DIR = "lists";
    private static final String FULLDIR = ApplicationManager.getRealPath();
    private static Map<String, ListData> lists = new HashMap<String, ListData>();

    public static void setListDir(String listDir) {
        LIST_DIR = listDir.replace('\\', '/');
    }

    public static void init() throws IOException {
        File root;
        String listDir = LIST_DIR.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        if (listDir.indexOf(SEP) == 0 && listDir.length() > 1) {
            listDir = listDir.substring(1);
        }
        if (!(root = new File(FULLDIR + SEP + listDir)).exists()) {
            return;
        }
        File[] files = root.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String filename;
            File f = files[i];
            if (f.isDirectory() || !(filename = f.getName()).endsWith(".i18n")) continue;
            int index = filename.indexOf(".i18n");
            String listname = filename.substring(0, index);
            if ((index = listname.indexOf("_")) > 0) {
                listname = listname.substring(0, index);
            }
            if (lists.get(listname) != null) continue;
            BaseListData list = new BaseListData(listname, 2, listDir);
            lists.put(listname, list);
        }
    }

    public static ListData getList(String listname) {
        return lists.get(listname);
    }

    public static void addList(ListData list) {
        lists.put(list.getName(), list);
    }

    public static List<ListData> getLists() {
        Collection<ListData> c = lists.values();
        ArrayList<ListData> list = new ArrayList<ListData>(c.size());
        Iterator<ListData> iter = c.iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public static void addList(DBListData list, ConnectionHandler connHandler) {
        list.load(connHandler);
        ListManager.addList(list);
    }

    public static ListData convert(Collection data, String keyProperty, String valueProperty) {
        return ListManager.convert("", data, keyProperty, valueProperty);
    }

    public static ListData convert(String listName, Collection data, String keyProperty, String valueProperty) {
        SimpleListData list = new SimpleListData(listName);
        if (data.isEmpty()) {
            return list;
        }
        Method keyMethod = null;
        Method valueMethod = null;
        Field keyField = null;
        Field valueField = null;
        try {
            Iterator iter = data.iterator();
            int counter = 0;
            while (iter.hasNext()) {
                Object element = iter.next();
                if (++counter == 1) {
                    keyMethod = InjectionUtils.findMethodToGet(element.getClass(), keyProperty);
                }
                String key = null;
                boolean ok = false;
                if (keyMethod == null) {
                    if (counter == 1) {
                        keyField = InjectionUtils.getField(element.getClass(), keyProperty);
                    }
                    if (keyField != null) {
                        key = (String)keyField.get(element);
                        ok = true;
                    }
                } else {
                    Object o = keyMethod.invoke(element, new Object[0]);
                    if (o != null) {
                        key = o.toString();
                        ok = true;
                    }
                }
                if (!ok) {
                    throw new RuntimeException("Unable find key for list: " + listName + " / " + keyProperty + " / " + valueProperty);
                }
                Object value = null;
                ok = false;
                if (counter == 1) {
                    valueMethod = InjectionUtils.findMethodToGet(element.getClass(), valueProperty);
                }
                if (valueMethod == null) {
                    if (counter == 1) {
                        valueField = InjectionUtils.getField(element.getClass(), valueProperty);
                    }
                    if (valueField != null) {
                        value = valueField.get(element);
                        ok = true;
                    }
                } else {
                    value = valueMethod.invoke(element, new Object[0]);
                    ok = true;
                }
                if (!ok) {
                    throw new RuntimeException("Unable to find value for list: " + listName + " / " + keyProperty + " / " + valueProperty);
                }
                list.add(key, value.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Erro generating list: " + listName + " / " + keyProperty + " / " + valueProperty, e);
        }
        return list;
    }

    public static String getValue(String listName, int id) {
        return ListManager.getValue(listName, String.valueOf(id));
    }

    public static String getValue(String listName, String id) {
        DBListData dbld;
        ListData list = ListManager.getList(listName);
        if (list == null) {
            return null;
        }
        if (list instanceof SimpleListData) {
            SimpleListData sld = (SimpleListData)list;
            return sld.getValue(id);
        }
        if (list instanceof DBListData && !(dbld = (DBListData)list).isLocalized()) {
            return dbld.getValue(id, null);
        }
        return list.getValue(id, LocaleManager.getDefaultLocale());
    }

    public static String getValue(String listName, int id, Locale loc) {
        return ListManager.getValue(listName, String.valueOf(id), loc);
    }

    public static String getValue(String listName, String id, Locale loc) {
        ListData list = ListManager.getList(listName);
        if (list != null) {
            return list.getValue(id, loc);
        }
        return null;
    }

    public static ListData convert(Collection data) {
        return ListManager.convert("", data);
    }

    public static ListData convert(String listName, Collection data) {
        SimpleListData list = new SimpleListData(listName);
        for (Object obj : data) {
            String value;
            String id;
            if (obj instanceof ListItem) {
                ListItem item = (ListItem)obj;
                id = item.getKey();
                value = item.getValue();
            } else {
                id = value = obj.toString();
            }
            list.add(id, value);
        }
        return list;
    }

    public static ListData convert(String listName, Enum[] enums, boolean i18n) {
        ListData list = i18n ? new I18nListData(listName) : new SimpleListData(listName);
        for (Enum enumer : enums) {
            String value;
            String id;
            if (enumer instanceof ListItem) {
                ListItem item = (ListItem)((Object)enumer);
                id = item.getKey();
                value = item.getValue();
            } else {
                id = enumer.name();
                value = enumer.getClass().getSimpleName() + '.' + enumer.name();
            }
            if (i18n) {
                ((I18nListData)list).add(id, value);
                continue;
            }
            ((SimpleListData)list).add(id, value);
        }
        return list;
    }

    public static ListData convert(Map data) {
        return ListManager.convert("", data);
    }

    public static ListData convert(String listName, Map data) {
        SimpleListData list = new SimpleListData(listName);
        try {
            Iterator iter = data.keySet().iterator();
            for (int i = 0; i < data.size(); ++i) {
                Object keyValue = iter.next();
                Object value = data.get(keyValue);
                list.add(keyValue.toString(), value.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Erro generating list: " + listName, e);
        }
        return list;
    }
}

