/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.list;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.mentawai.core.ApplicationManager;
import org.mentawai.i18n.I18N;
import org.mentawai.i18n.I18NHolder;
import org.mentawai.i18n.I18NMap;
import org.mentawai.i18n.LocaleManager;
import org.mentawai.list.ListData;
import org.mentawai.list.ListDataItem;
import org.mentawai.list.ListItem;
import org.mentawai.list.ListManager;

public class I18nListData
implements ListData {
    private static final String SEP = File.separator;
    private static final String FULLDIR = ApplicationManager.getRealPath();
    private Map<String, String> map = new LinkedHashMap<String, String>();
    private I18NHolder i18n = new I18NHolder();
    private Set<Locale> locales = new HashSet<Locale>();
    private String name;

    public I18nListData(String listname) {
        File[] files;
        this.name = listname;
        File root = new File(FULLDIR + SEP + ListManager.LIST_DIR);
        if (!root.exists()) {
            return;
        }
        for (File file : files = root.listFiles()) {
            String filename;
            if (file.isDirectory() || !(filename = file.getName()).endsWith(".i18n") || !filename.startsWith(this.name + "_")) continue;
            Locale l = this.getLocale(file, listname);
            I18N i18n = I18NMap.getI18N(file);
            if (i18n == null) continue;
            this.i18n.add(l, i18n);
            this.locales.add(l);
        }
    }

    private Locale getLocale(File file, String listname) {
        String filename = file.getName();
        filename = filename.substring(0, filename.indexOf(".i18n"));
        String[] s = (filename = filename.substring(listname.length() + 1)).split("_");
        if (s.length == 1) {
            return new Locale(s[0]);
        }
        if (s.length == 2) {
            return new Locale(s[0], s[1]);
        }
        return LocaleManager.getDefaultLocale();
    }

    private Locale getAnyLocale() {
        Iterator<Locale> i$ = this.locales.iterator();
        if (i$.hasNext()) {
            Locale loc = i$.next();
            return loc;
        }
        return null;
    }

    public void add(String id, String i18nKey) {
        if (!this.map.containsKey(id)) {
            this.map.put(id, i18nKey);
        }
    }

    @Override
    public String getValue(String id, Locale loc) {
        I18N i18n = this.i18n.get(loc);
        if (i18n == null) {
            return null;
        }
        String key = this.map.get(id);
        if (key == null) {
            return null;
        }
        return i18n.get(key);
    }

    @Override
    public String getValue(String id) {
        String value = this.getValue(id, LocaleManager.getDefaultLocale());
        if (value == null) {
            for (Locale loc : this.locales) {
                value = this.getValue(id, loc);
                if (value == null) continue;
                return value;
            }
        }
        return value;
    }

    @Override
    public String getValue(int id) {
        return this.getValue(String.valueOf(id));
    }

    @Override
    public String getValue(int id, Locale loc) {
        return this.getValue(String.valueOf(id), loc);
    }

    @Override
    public List<ListItem> getValues() {
        return this.getValues(LocaleManager.getDefaultLocale());
    }

    @Override
    public List<ListItem> getValues(Locale loc) {
        Locale l;
        I18N i18n = this.i18n.get(loc);
        if (i18n == null) {
            i18n = this.i18n.get(LocaleManager.getDefaultLocale());
        }
        if (i18n == null && (l = this.getAnyLocale()) != null) {
            i18n = this.i18n.get(l);
        }
        if (i18n == null) {
            return new ArrayList<ListItem>(0);
        }
        Set<String> keys = this.map.keySet();
        ArrayList<ListItem> list = new ArrayList<ListItem>();
        for (String key : keys) {
            String value = i18n.get(key);
            if (value == null) continue;
            list.add(new ListDataItem(key, value));
        }
        return list;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public String toString() {
        if (this.map.isEmpty()) {
            return "{}";
        }
        Set<String> keys = this.map.keySet();
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            if (sb.length() == 0) {
                sb.append('{');
            } else {
                sb.append(',').append('\n');
            }
            sb.append(key);
            sb.append('=');
            String value = this.map.get(key);
            sb.append(value != null ? value : "NULL");
        }
        sb.append('}');
        return sb.toString();
    }
}

