/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.list;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.mentawai.db.ConnectionHandler;
import org.mentawai.list.ListData;
import org.mentawai.list.ListDataItemJPA;
import org.mentawai.list.ListItem;
import org.mentawai.list.LocalizedListData;
import org.mentawai.list.SimpleListData;
import org.mentawai.util.JPAHelper;

public class DBListData
implements ListData,
Runnable {
    private LocalizedListData data;
    private SimpleListData noI18nData;
    private final boolean isLocalized;
    private final String name;
    private final String keyColumn;
    private final String valueColumn;
    private final String localeColumn;
    private final String tableName;
    private final String orderByColumn;
    private Thread thread = null;
    private long threadTime;
    private volatile boolean bThread;
    private ConnectionHandler connHandler;
    private String where = null;

    public DBListData(String name, String keyColumn, String valueColumn, String localeColumn, String tableName, String orderByColumn) {
        this.name = name;
        this.isLocalized = true;
        this.keyColumn = keyColumn;
        this.valueColumn = valueColumn;
        this.localeColumn = localeColumn;
        this.tableName = tableName;
        this.orderByColumn = orderByColumn;
    }

    public DBListData(String name, String keyColumn, String valueColumn, String tableName, String orderByColumn) {
        this.name = name;
        this.isLocalized = false;
        this.keyColumn = keyColumn;
        this.valueColumn = valueColumn;
        this.localeColumn = null;
        this.tableName = tableName;
        this.orderByColumn = orderByColumn;
    }

    public DBListData(String name) {
        this(name, "ID");
    }

    public DBListData(String name, String orderBy) {
        this(name, "ID", "VALUE", name, orderBy);
    }

    public boolean isLocalized() {
        return this.isLocalized;
    }

    public void setWhere(String where) {
        String s;
        this.where = where == null || where.trim().equals("") ? null : ((s = where.trim().toLowerCase()).startsWith("where") ? where.trim() : "where " + where.trim());
    }

    public void startAutoRefresh(ConnectionHandler connHandler, long time) {
        this.stopAutoRefresh();
        this.connHandler = connHandler;
        this.threadTime = time;
        this.thread = new Thread(this);
        this.bThread = true;
        this.thread.start();
    }

    public void stopAutoRefresh() {
        if (this.thread != null) {
            this.bThread = false;
            this.thread.interrupt();
            this.thread = null;
            this.connHandler = null;
        }
    }

    @Override
    public void run() {
        while (this.bThread) {
            try {
                Thread.sleep(this.threadTime);
            }
            catch (Exception e) {
                return;
            }
            try {
                this.refresh(this.connHandler);
            }
            catch (SQLException e) {
                System.err.println("Unable to refresh list!");
                e.printStackTrace();
            }
        }
    }

    private void checkList(Object obj) {
        if (obj == null) {
            throw new IllegalStateException("List is not loaded: " + this.name);
        }
    }

    @Override
    public synchronized int size() {
        if (this.isLocalized) {
            this.checkList(this.data);
            return this.data.size();
        }
        this.checkList(this.noI18nData);
        return this.noI18nData.size();
    }

    @Override
    public synchronized String getValue(String key, Locale loc) {
        if (this.isLocalized) {
            this.checkList(this.data);
            return this.data.getValue(key, loc);
        }
        this.checkList(this.noI18nData);
        return this.noI18nData.getValue(key, loc);
    }

    @Override
    public synchronized String getValue(String key) {
        if (this.isLocalized) {
            return this.data.getValue(key);
        }
        return this.noI18nData.getValue(key);
    }

    @Override
    public synchronized String getValue(int key) {
        return this.getValue(String.valueOf(key));
    }

    @Override
    public synchronized String getValue(int key, Locale loc) {
        if (this.isLocalized) {
            this.checkList(this.data);
            return this.data.getValue(key, loc);
        }
        this.checkList(this.noI18nData);
        return this.noI18nData.getValue(key, loc);
    }

    @Override
    public synchronized List<ListItem> getValues(Locale loc) {
        if (this.isLocalized) {
            this.checkList(this.data);
            return this.data.getValues(loc);
        }
        this.checkList(this.noI18nData);
        return this.noI18nData.getValues(loc);
    }

    @Override
    public synchronized List<ListItem> getValues() {
        if (this.isLocalized) {
            return this.data.getValues();
        }
        return this.noI18nData.getValues();
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected Locale getLocaleFromString(String loc) {
        StringTokenizer st = new StringTokenizer(loc, "_");
        int x = st.countTokens();
        if (x == 1) {
            return new Locale(st.nextToken());
        }
        if (x == 2) {
            return new Locale(st.nextToken(), st.nextToken());
        }
        if (x == 3) {
            return new Locale(st.nextToken(), st.nextToken(), st.nextToken());
        }
        throw new IllegalArgumentException("Bad locale: " + loc);
    }

    public void load(ConnectionHandler connHandler) {
        Connection conn = null;
        try {
            conn = connHandler.getConnection();
            this.load(conn);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            connHandler.release(conn);
        }
    }

    protected String buildSQL(boolean isLocalized) {
        if (isLocalized) {
            return "select " + this.keyColumn + "," + this.valueColumn + "," + this.localeColumn + " from " + this.tableName + " " + (this.where != null ? this.where : "") + " order by " + this.orderByColumn;
        }
        return "select " + this.keyColumn + "," + this.valueColumn + " from " + this.tableName + " " + (this.where != null ? this.where : "") + " order by " + this.orderByColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Connection conn) {
        HashMap<String, Locale> locales = new HashMap<String, Locale>();
        LocalizedListData data = null;
        SimpleListData noI18nData = null;
        if (this.isLocalized) {
            data = new LocalizedListData(this.name);
        } else {
            noI18nData = new SimpleListData(this.name);
        }
        String sql = this.buildSQL(data != null);
        PreparedStatement stmt = null;
        ResultSet rset = null;
        try {
            Object key;
            stmt = conn.prepareStatement(sql);
            rset = stmt.executeQuery();
            while (rset.next()) {
                key = rset.getString(1);
                String value = rset.getString(2);
                if (data != null) {
                    String loc = rset.getString(3);
                    Locale locale = (Locale)locales.get(loc);
                    if (locale == null) {
                        locale = this.getLocaleFromString(loc);
                        if (locale == null) {
                            throw new IllegalArgumentException("method getLocaleFromString returned null for: " + loc);
                        }
                        locales.put(loc, locale);
                    }
                    data.add((String)key, value, locale);
                    continue;
                }
                noI18nData.add((String)key, value);
            }
            key = this;
            synchronized (key) {
                this.data = data;
                this.noI18nData = noI18nData;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (Exception e) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUsingJPA() {
        String value;
        String key;
        if (!JPAHelper.existsJPAPersistenceUnit()) {
            throw new IllegalArgumentException("undefined JPA Persistence Unit! Please use JPAHelper.setPersistenceUnit in your ApplicationManager.");
        }
        HashMap<String, Locale> locales = new HashMap<String, Locale>();
        LocalizedListData data = null;
        SimpleListData noI18nData = null;
        if (this.isLocalized) {
            data = new LocalizedListData(this.name);
        } else {
            noI18nData = new SimpleListData(this.name);
        }
        String sql = this.buildSQL(data != null);
        EntityManager em = JPAHelper.getEntityManagerForQueries();
        Query query = em.createQuery(sql);
        List result = query.getResultList();
        JPAHelper.closeEntityManagerForQueries(em);
        ArrayList<ListDataItemJPA> listDataItemResult = new ArrayList<ListDataItemJPA>();
        for (Object[] resultElement : result) {
            key = null;
            key = resultElement[0] instanceof String ? (String)resultElement[0] : String.valueOf(resultElement[0]);
            value = null;
            value = resultElement[1] instanceof String ? (String)resultElement[1] : String.valueOf(resultElement[1]);
            if (this.isLocalized) {
                String loc = (String)resultElement[2];
                listDataItemResult.add(new ListDataItemJPA(key, value, loc));
                continue;
            }
            listDataItemResult.add(new ListDataItemJPA(key, value));
        }
        for (ListDataItemJPA listDataItem : listDataItemResult) {
            key = listDataItem.getKey();
            value = listDataItem.getValue();
            if (data != null) {
                String loc = listDataItem.getLoc();
                Locale locale = (Locale)locales.get(loc);
                if (locale == null) {
                    locale = this.getLocaleFromString(loc);
                    if (locale == null) {
                        throw new IllegalArgumentException("method getLocaleFromString returned null for: " + loc);
                    }
                    locales.put(loc, locale);
                }
                data.add(key, value, locale);
                continue;
            }
            noI18nData.add(key, value);
        }
        DBListData dBListData = this;
        synchronized (dBListData) {
            this.data = data;
            this.noI18nData = noI18nData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(ConnectionHandler connHandler) throws SQLException {
        Connection conn = null;
        try {
            conn = connHandler.getConnection();
            this.refresh(conn);
        }
        finally {
            connHandler.release(conn);
        }
    }

    public void refresh(Connection conn) throws SQLException {
        this.load(conn);
    }
}

