/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.list;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import org.mentawai.db.ConnectionHandler;
import org.mentawai.list.ListData;
import org.mentawai.list.ListItem;

public abstract class CustomListData
implements ListData,
Runnable {
    private ListData listData;
    private final String name;
    private Thread thread = null;
    private long threadTime;
    private volatile boolean bThread;
    private ConnectionHandler connHandler;

    public CustomListData(String name) {
        this.name = name;
    }

    public void startAutoRefresh(ConnectionHandler connHandler, long time) {
        this.stopAutoRefresh();
        this.connHandler = connHandler;
        this.threadTime = time;
        this.thread = new Thread(this);
        this.bThread = true;
        this.thread.start();
    }

    public void stopAutoRefresh() {
        if (this.thread != null) {
            this.bThread = false;
            this.thread.interrupt();
            this.thread = null;
            this.connHandler = null;
        }
    }

    @Override
    public void run() {
        while (this.bThread) {
            try {
                Thread.sleep(this.threadTime);
            }
            catch (Exception e) {
                return;
            }
            try {
                this.refresh(this.connHandler);
            }
            catch (SQLException e) {
                System.err.println("Unable to refresh list!");
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized int size() {
        return this.listData.size();
    }

    @Override
    public synchronized String getValue(String key, Locale loc) {
        return this.listData.getValue(key, loc);
    }

    @Override
    public synchronized String getValue(String key) {
        return this.listData.getValue(key);
    }

    @Override
    public synchronized String getValue(int key) {
        return this.listData.getValue(key);
    }

    @Override
    public synchronized String getValue(int key, Locale loc) {
        return this.listData.getValue(key, loc);
    }

    @Override
    public synchronized List<ListItem> getValues(Locale loc) {
        return this.listData.getValues(loc);
    }

    @Override
    public synchronized List<ListItem> getValues() {
        return this.listData.getValues();
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(ConnectionHandler connHandler) throws SQLException {
        Connection conn = null;
        try {
            conn = connHandler.getConnection();
            ListData data = this.load(conn);
            CustomListData customListData = this;
            synchronized (customListData) {
                this.listData = data;
            }
        }
        finally {
            connHandler.release(conn);
        }
    }

    public abstract ListData load(Connection var1) throws SQLException;

    public void refresh(ConnectionHandler connHandler) throws SQLException {
        this.load(connHandler);
    }

    public void refresh(Connection conn) throws SQLException {
        this.load(conn);
    }
}

