/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.list;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.mentawai.core.ApplicationManager;
import org.mentawai.i18n.I18N;
import org.mentawai.i18n.I18NMap;
import org.mentawai.i18n.LocaleManager;
import org.mentawai.list.ListData;
import org.mentawai.list.ListDataItem;
import org.mentawai.list.ListItem;
import org.mentawai.list.ListManager;
import org.mentawai.util.StringComparator;

public class BaseListData
implements ListData {
    private static final String FULLDIR = ApplicationManager.getRealPath();
    private static final String SEP = File.separator;
    public static final int ORDER_BY_ID = 1;
    public static final int ORDER_BY_STRING_ID = 4;
    public static final int ORDER_BY_VALUE = 2;
    public static final int ORDER_BY_FILE = 3;
    private String listname;
    private String listDir;
    private Map<Locale, List<ListItem>> map = new HashMap<Locale, List<ListItem>>();
    private Map<Locale, Map<String, ListItem>> values = new HashMap<Locale, Map<String, ListItem>>();
    private int size = 0;

    public BaseListData(String listname, int ordertype, String listDir) throws IOException {
        this.listname = listname;
        this.listDir = listDir;
        this.load(ordertype);
    }

    public BaseListData(String listname, int ordertype) throws IOException {
        this(listname, ordertype, ListManager.LIST_DIR);
    }

    public BaseListData(String listname) throws IOException {
        this(listname, 2, ListManager.LIST_DIR);
    }

    @Override
    public String getName() {
        return this.listname;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public List<ListItem> getValues(Locale loc) {
        if (this.map.containsKey(loc)) {
            return this.map.get(loc);
        }
        if (!this.map.isEmpty()) {
            return this.map.values().iterator().next();
        }
        return new ArrayList<ListItem>(0);
    }

    @Override
    public List<ListItem> getValues() {
        return this.getValues(LocaleManager.getDefaultLocale());
    }

    @Override
    public String getValue(String id, Locale loc) {
        Map<String, ListItem> m = null;
        if (this.values.containsKey(loc)) {
            m = this.values.get(loc);
        } else if (!this.values.isEmpty()) {
            m = this.values.values().iterator().next();
        } else {
            return "!" + id + "!";
        }
        ListItem item = m.get(id);
        if (item == null) {
            return "!!" + id + "!!";
        }
        return item.getValue();
    }

    @Override
    public String getValue(String id) {
        String value = this.getValue(id, LocaleManager.getDefaultLocale());
        if (value == null) {
            for (Map<String, ListItem> map : this.values.values()) {
                ListItem item = map.get(id);
                if (item == null) continue;
                return item.getValue();
            }
        }
        return value;
    }

    @Override
    public String getValue(int id) {
        return this.getValue(String.valueOf(id));
    }

    @Override
    public String getValue(int id, Locale loc) {
        return this.getValue(String.valueOf(id), loc);
    }

    private List<String> loadFileToList(Locale loc) throws IOException {
        String line;
        File file = new File(FULLDIR + SEP + this.listDir + SEP + this.listname + "_" + loc.toString() + ".i18n");
        if (!file.exists() || file.isDirectory()) {
            throw new IOException("Could not find list file: " + file);
        }
        FileInputStream fis = new FileInputStream(file);
        BufferedReader in = new BufferedReader(new InputStreamReader(fis));
        ArrayList<String> lines = new ArrayList<String>(1000);
        while ((line = in.readLine()) != null) {
            lines.add(line);
        }
        in.close();
        return lines;
    }

    private I18N loadI18N(Locale loc) throws IOException {
        I18N i18n = I18NMap.getI18N(SEP + this.listDir + SEP + this.listname + "_" + loc.toString() + ".i18n");
        if (i18n != null) {
            return i18n;
        }
        i18n = I18NMap.getI18N(SEP + this.listDir + SEP + this.listname + "_" + loc.getLanguage() + ".i18n");
        if (i18n != null) {
            return i18n;
        }
        throw new IOException("Could not find i18n file for list: " + this.listname);
    }

    private String getIdFromLine(String line) {
        if (line.indexOf(61) > 0) {
            StringTokenizer st = new StringTokenizer(line, "=");
            String key = st.nextToken().trim();
            return key;
        }
        return null;
    }

    protected void sort(List<ListItem> list, int ordertype) {
        if (ordertype == 1) {
            Collections.sort(list, new IdComparator());
        } else if (ordertype == 2) {
            Collections.sort(list, new ValueComparator());
        } else if (ordertype == 4) {
            Collections.sort(list, new StringIdComparator());
        }
    }

    private void load(int ordertype) throws IOException {
        Set<Locale> set = null;
        try {
            set = LocaleManager.scanLocales(this.listDir, this.listname);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (set == null || set.isEmpty()) {
            throw new IOException("Cannot find locales for list: " + this.listname + " / " + this.listDir);
        }
        Locale locDef = LocaleManager.getDefaultLocale();
        if (!set.contains(locDef)) {
            locDef = set.iterator().next();
        }
        I18N i18nDef = this.loadI18N(locDef);
        if (ordertype != 3) {
            for (Locale loc : set) {
                I18N i18n = this.loadI18N(loc);
                Iterator<String> iter = i18nDef.keys();
                ArrayList<ListItem> list = new ArrayList<ListItem>(1000);
                HashMap<String, ListDataItem> m = new HashMap<String, ListDataItem>();
                while (iter.hasNext()) {
                    String key = iter.next();
                    String value = i18n.get(key);
                    if (value == null && (value = i18nDef.get(key)) == null) {
                        value = "!NULL!";
                    }
                    ListDataItem item = new ListDataItem(key, value);
                    list.add(item);
                    m.put(item.getKey(), item);
                }
                this.sort(list, ordertype);
                this.map.put(loc, list);
                this.values.put(loc, m);
                if (list.size() <= this.size) continue;
                this.size = list.size();
            }
        } else {
            for (Locale loc : set) {
                List<String> lines = this.loadFileToList(loc);
                I18N i18n = this.loadI18N(loc);
                Iterator<String> iter = lines.iterator();
                ArrayList<ListDataItem> list = new ArrayList<ListDataItem>(1000);
                HashMap<String, ListDataItem> m = new HashMap<String, ListDataItem>();
                while (iter.hasNext()) {
                    String line = iter.next();
                    String key = this.getIdFromLine(line);
                    if (key == null) continue;
                    String value = i18n.get(key);
                    if (value == null && (value = i18nDef.get(key)) == null) {
                        value = "!NULL!";
                    }
                    ListDataItem item = new ListDataItem(key, value);
                    list.add(item);
                    m.put(item.getKey(), item);
                }
                this.map.put(loc, list);
                this.values.put(loc, m);
                if (list.size() <= this.size) continue;
                this.size = list.size();
            }
        }
    }

    private static class ValueComparator
    extends StringComparator {
        private ValueComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            ListItem l1 = (ListItem)o1;
            ListItem l2 = (ListItem)o2;
            return super.compare(l1.getValue(), l2.getValue());
        }
    }

    private static class StringIdComparator
    extends StringComparator {
        private StringIdComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            ListItem l1 = (ListItem)o1;
            ListItem l2 = (ListItem)o2;
            String id1 = l1.getKey();
            String id2 = l2.getKey();
            return super.compare(id1, id2);
        }
    }

    private static class IdComparator
    implements Comparator<ListItem> {
        private IdComparator() {
        }

        @Override
        public int compare(ListItem l1, ListItem l2) {
            int id1 = -1;
            int id2 = -1;
            try {
                id1 = Integer.parseInt(l1.getKey());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                id2 = Integer.parseInt(l2.getKey());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            return id1 - id2;
        }
    }
}

