/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.jruby;

import org.jruby.RubyObject;
import org.mentawai.core.Action;
import org.mentawai.core.ActionConfig;
import org.mentawai.jruby.JRubyInterpreter;
import org.mentawai.jruby.RubyAction;

public class RubyActionConfig
extends ActionConfig {
    private JRubyInterpreter ruby = JRubyInterpreter.getInstance();
    private static long ruby_object_id = 0L;
    private final String ruby_klass_name;

    private static Class<? extends Object> getRubyClass(String name) {
        RubyObject o = JRubyInterpreter.getInstance().eval(name + ".new");
        return o.getClass();
    }

    public RubyActionConfig(String klass) {
        super(RubyActionConfig.getRubyClass(klass));
        this.ruby_klass_name = klass;
    }

    public RubyActionConfig(String name, String klass) {
        super(name, RubyActionConfig.getRubyClass(klass));
        this.ruby_klass_name = klass;
    }

    public RubyActionConfig(String name, String klass, String innerAction) {
        super(name, RubyActionConfig.getRubyClass(klass), innerAction);
        this.ruby_klass_name = klass;
    }

    private static synchronized long getNextActionId() {
        ruby_object_id = ruby_object_id < Long.MAX_VALUE ? ++ruby_object_id : 1L;
        return ruby_object_id;
    }

    @Override
    public Action getAction() {
        try {
            long nextActionId = RubyActionConfig.getNextActionId();
            Object obj = this.ruby.createAction(nextActionId, this.ruby_klass_name);
            return new RubyAction(nextActionId, obj, this.ruby_klass_name);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

