/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.jruby;

import java.util.Locale;
import org.mentawai.core.Action;
import org.mentawai.core.Context;
import org.mentawai.core.Input;
import org.mentawai.core.Output;
import org.mentawai.jruby.JRubyInterpreter;

public class RubyAction
implements Action {
    private JRubyInterpreter ruby = JRubyInterpreter.getInstance();
    private Input input;
    private Output output;
    private Context session;
    private Context application;
    private Locale locale;
    private Context cookies;
    private final Object rubyObject;
    private final long rubyActionId;
    private final String actionName;
    private static final ThreadLocal<Action> action = new ThreadLocal();

    public RubyAction(long rubyActionId, Object rubyObject, String actionName) {
        this.rubyObject = rubyObject;
        this.rubyActionId = rubyActionId;
        String[] s = actionName.split("\\:\\:");
        this.actionName = s[s.length - 1];
        action.set(this);
    }

    public Object getRubyObject() {
        return this.rubyObject;
    }

    public long getRubyActionId() {
        return this.rubyActionId;
    }

    public static Action getAction() {
        return action.get();
    }

    public String getActionName() {
        return this.actionName;
    }

    public String execute() throws Exception {
        throw new UnsupportedOperationException("This action is not meant to be executed!");
    }

    @Override
    public void setInput(Input input) {
        this.input = input;
        if (this.ruby.respondTo(this.rubyObject, "setInput")) {
            this.ruby.set(this.rubyObject, "setInput", input);
        }
    }

    @Override
    public void setOutput(Output output) {
        this.output = output;
        if (this.ruby.respondTo(this.rubyObject, "setOutput")) {
            this.ruby.set(this.rubyObject, "setOutput", output);
        }
    }

    @Override
    public void setSession(Context context) {
        this.session = context;
        if (this.ruby.respondTo(this.rubyObject, "setSession")) {
            this.ruby.set(this.rubyObject, "setSession", context);
        }
    }

    @Override
    public void setApplication(Context context) {
        this.application = context;
        if (this.ruby.respondTo(this.rubyObject, "setApplication")) {
            this.ruby.set(this.rubyObject, "setApplication", context);
        }
    }

    @Override
    public void setCookies(Context context) {
        this.cookies = context;
        if (this.ruby.respondTo(this.rubyObject, "setCookies")) {
            this.ruby.set(this.rubyObject, "setCookies", context);
        }
    }

    @Override
    public void setLocale(Locale loc) {
        this.locale = loc;
        if (this.ruby.respondTo(this.rubyObject, "setLocale")) {
            this.ruby.set(this.rubyObject, "setLocale", loc);
        }
    }

    @Override
    public Input getInput() {
        return this.input;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public Context getSession() {
        return this.session;
    }

    @Override
    public Context getApplication() {
        return this.application;
    }

    @Override
    public Context getCookies() {
        return this.cookies;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    protected void finalize() {
        JRubyInterpreter ruby = JRubyInterpreter.getInstance();
        ruby.removeAction(this.rubyActionId);
    }
}

