/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.jruby;

import org.jruby.RubyObject;
import org.mentawai.jruby.JRubyInterpreter;

public class JRubyWrapper {
    private final RubyObject rubyObject;

    public JRubyWrapper(RubyObject rubyObject) {
        this.rubyObject = rubyObject;
    }

    public Object call(String methodName) {
        JRubyInterpreter ruby = JRubyInterpreter.getInstance();
        return ruby.call(this.rubyObject, methodName);
    }

    public Object call(String methodName, Class<? extends Object> returnType) {
        JRubyInterpreter ruby = JRubyInterpreter.getInstance();
        return ruby.call((Object)this.rubyObject, methodName, returnType);
    }

    public Object call(String methodName, Class<? extends Object> returnType, Object ... params) {
        JRubyInterpreter ruby = JRubyInterpreter.getInstance();
        return ruby.call((Object)this.rubyObject, methodName, returnType, params);
    }

    public Object call(String methodName, Object ... params) {
        JRubyInterpreter ruby = JRubyInterpreter.getInstance();
        return ruby.call((Object)this.rubyObject, methodName, params);
    }

    public Object callStatic(String methodName) {
        JRubyInterpreter ruby = JRubyInterpreter.getInstance();
        return ruby.call(this.rubyObject.getMetaClass(), methodName);
    }

    public Object callStatic(String methodName, Class<? extends Object> returnType) {
        JRubyInterpreter ruby = JRubyInterpreter.getInstance();
        return ruby.call((Object)this.rubyObject.getMetaClass(), methodName, returnType);
    }

    public Object callStatic(String methodName, Class<? extends Object> returnType, Object ... params) {
        JRubyInterpreter ruby = JRubyInterpreter.getInstance();
        return ruby.call((Object)this.rubyObject.getMetaClass(), methodName, returnType, params);
    }

    public Object callStatic(String methodName, Object ... params) {
        JRubyInterpreter ruby = JRubyInterpreter.getInstance();
        return ruby.call((Object)this.rubyObject.getMetaClass(), methodName, params);
    }

    public boolean respondTo(String methodName) {
        JRubyInterpreter ruby = JRubyInterpreter.getInstance();
        return ruby.respondTo(this.rubyObject, methodName);
    }

    public Object set(String propName, Object value) {
        JRubyInterpreter ruby = JRubyInterpreter.getInstance();
        return ruby.set(this.rubyObject, propName, value);
    }

    public Object getRubyObject() {
        return this.rubyObject;
    }
}

