/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.jruby;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyRuntimeAdapter;
import org.jruby.ext.posix.util.Platform;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;
import org.mentawai.core.ApplicationManager;

public class JRubyInterpreter
implements Runnable {
    public static long RELOAD_INTERVAL = 5000L;
    private static JRubyInterpreter instance = null;
    private Ruby runtime;
    private RubyRuntimeAdapter evaler;
    private Object rubyLoader = null;
    private final Thread thread;
    private volatile boolean running;
    private static final Object[] EMPTY = new Object[0];

    private JRubyInterpreter() throws IOException {
        boolean isWindows = Platform.IS_WINDOWS;
        String SEP = isWindows ? "\\" : "/";
        String jruby_home = System.getenv("JRUBY_HOME");
        String jruby_lib = System.getenv("JRUBY_LIB");
        String jruby_shell = System.getenv("JRUBY_SHELL");
        String jruby_script = System.getenv("JRUBY_SCRIPT");
        String jruby_opts = System.getenv("JRUBY_OPTS");
        if (jruby_home != null) {
            System.setProperty("jruby.home", jruby_home);
        }
        if (jruby_lib != null) {
            System.setProperty("jruby.lib", jruby_lib);
        } else if (jruby_home != null) {
            System.setProperty("jruby.lib", jruby_home + SEP + "lib");
        }
        if (jruby_shell != null) {
            System.setProperty("jruby.shell", jruby_shell);
        } else if (isWindows) {
            System.setProperty("jruby.shell", "cmd.exe");
        } else {
            System.setProperty("jruby.shell", "/bin/sh");
        }
        if (jruby_script != null) {
            System.setProperty("jruby.script", jruby_script);
        } else if (isWindows) {
            System.setProperty("jruby.script", "jruby.bat");
        } else {
            System.setProperty("jruby.script", "jruby");
        }
        String realPath = ApplicationManager.getRealPath();
        ArrayList<String> loadPaths = new ArrayList<String>();
        loadPaths.add(".");
        loadPaths.add(realPath + SEP + "WEB-INF" + SEP + "ruby");
        this.runtime = JavaEmbedUtils.initialize(loadPaths);
        this.evaler = JavaEmbedUtils.newRuntimeAdapter();
        if (jruby_home != null && jruby_opts != null && jruby_opts.indexOf("-rubygems") != -1) {
            this.require("rubygems");
        }
        if (jruby_home != null && jruby_opts != null && jruby_opts.indexOf("-K") != -1) {
            int start = jruby_opts.indexOf("-K");
            String s = jruby_opts.substring(start + 2);
            int end = s.indexOf(" ");
            if (end > 0) {
                s = s.substring(0, end);
            }
            this.eval("$KCODE = '" + s + "'");
        }
        this.loadFileFromClasspath("org/mentawai/jruby/loader.rb");
        this.loadFileFromClasspath("org/mentawai/jruby/action_manager.rb");
        this.loadFileFromClasspath("org/mentawai/jruby/utils.rb");
        this.loadFileFromClasspath("org/mentawai/jruby/ruby_action.rb");
        this.rubyLoader = this.eval("Mentawai::JRuby::Loader.new('" + realPath + "')");
        this.reloadFiles();
        this.thread = new Thread(this);
        this.running = true;
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Thread.sleep(RELOAD_INTERVAL);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                if (!this.running) continue;
                this.reloadFiles();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void close() {
        this.running = false;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<String> getSetters(Object rubyObject) {
        RubyClass rubyClass = ((RubyObject)rubyObject).getMetaClass();
        Map map = rubyClass.getMethods();
        ArrayList<String> setters = new ArrayList<String>(map.size());
        for (String m : map.keySet()) {
            if (m.length() <= 1 || m.equals("==") || m.equals("===") || !m.endsWith("=")) continue;
            setters.add(m);
        }
        return setters;
    }

    private void reloadFiles() {
        this.call(this.rubyLoader, "reloadFiles");
    }

    public void require(String file) {
        this.eval("require '" + file + "'");
    }

    public RubyObject eval(String code) {
        IRubyObject obj = this.evaler.eval(this.runtime, code);
        if (obj == null) {
            return null;
        }
        if (obj instanceof RubyObject) {
            return (RubyObject)obj;
        }
        System.err.println("Object created by eval is not a RubyObject: " + obj.getClass());
        return null;
    }

    public String callAction(Object rubyObject, String methodName) {
        Object obj = this.call(rubyObject, methodName);
        return obj != null ? obj.toString() : null;
    }

    private Object callMethodImpl(Object rubyObject, String methodName, Object[] params, Class<? extends Object> returnType) {
        String[] s = methodName.split("\\.");
        if (s.length == 1) {
            return JavaEmbedUtils.invokeMethod((Ruby)this.runtime, (Object)rubyObject, (String)methodName, (Object[])params, returnType);
        }
        String m1 = s[0];
        String m2 = JRubyInterpreter.getMethods(s);
        Object temp = JavaEmbedUtils.invokeMethod((Ruby)this.runtime, (Object)rubyObject, (String)m1, (Object[])EMPTY, Object.class);
        return this.callMethodImpl(temp, m2, params, returnType);
    }

    public Object call(Object rubyObject, String methodName) {
        return this.callMethodImpl(rubyObject, methodName, EMPTY, Object.class);
    }

    public Object call(Object rubyObject, String methodName, Class<? extends Object> returnType) {
        return this.callMethodImpl(rubyObject, methodName, EMPTY, returnType);
    }

    public Object call(Object rubyObject, String methodName, Object ... params) {
        return this.callMethodImpl(rubyObject, methodName, params, Object.class);
    }

    public Object call(Object rubyObject, String methodName, Class<? extends Object> returnType, Object ... params) {
        return this.callMethodImpl(rubyObject, methodName, params, returnType);
    }

    public Object set(Object rubyObject, String propName, Object value) {
        return this.call(rubyObject, propName + "=", value);
    }

    public boolean respondTo(Object rubyObject, String methodName) {
        Object res = JavaEmbedUtils.invokeMethod((Ruby)this.runtime, (Object)rubyObject, (String)"respond_to?", (Object[])new Object[]{methodName}, Object.class);
        if (res instanceof Boolean) {
            return (Boolean)res;
        }
        throw new RuntimeException("Problem calling respond_to?!");
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public static synchronized JRubyInterpreter getInstance() {
        if (instance == null) {
            try {
                instance = new JRubyInterpreter();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return instance;
    }

    public void loadFileFromClasspath(String filename) throws IOException {
        String line;
        InputStream is = this.getResourceAsStream(filename);
        if (is == null) {
            throw new IOException("Cannot find resource: " + filename);
        }
        StringBuilder sb = new StringBuilder(1024);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            sb.append(line).append('\n');
        }
        this.eval(sb.toString());
    }

    private InputStream getResourceAsStream(String name) {
        InputStream inStream = null;
        Class<?> c = this.getClass();
        ClassLoader classLoader = c.getClassLoader();
        if (classLoader != null) {
            inStream = classLoader.getResourceAsStream(name);
        }
        if (inStream == null) {
            inStream = ClassLoader.getSystemResourceAsStream(name);
        }
        return inStream;
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    void removeAction(long id) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Mentawai::JRuby::ActionManager.instance.del_action(").append(id).append(")");
        this.eval(sb.toString());
    }

    Object createAction(long id, String ruby_klass_name) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Mentawai::JRuby::ActionManager.instance.add_action(").append(id);
        sb.append(", '").append(ruby_klass_name).append("')");
        return this.eval(sb.toString());
    }

    Object getAction(long id) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Mentawai::JRuby::ActionManager.instance.get_action(").append(id).append(")");
        return this.eval(sb.toString());
    }

    private static String getMethods(String[] s) {
        StringBuilder sb = new StringBuilder(32);
        for (int i = 1; i < s.length; ++i) {
            if (i > 1) {
                sb.append('.');
            }
            sb.append(s[i]);
        }
        return sb.toString();
    }
}

