/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.ioc;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.mentawai.log.Debug;
import org.mentawai.util.InjectionUtils;

public class Dependency {
    private Map<Object, Object> received = new WeakHashMap<Object, Object>();
    private static final String NAME = "Dependency";
    private final String target;
    private String source;
    private final Class<? extends Object> klass;
    private Map<String, AccessibleObject> cache = new HashMap<String, AccessibleObject>();

    public Dependency(Class<? extends Object> klass, String target, String source) {
        this.klass = klass;
        this.target = target;
        this.source = source;
    }

    public Dependency(Class<? extends Object> klass, String target) {
        this(klass, target, target);
    }

    public Dependency source(String source) {
        this.source = source;
        return this;
    }

    public String getTarget() {
        return this.target;
    }

    public String getSource() {
        return this.source;
    }

    public Class<? extends Object> getDependencyClass() {
        return this.klass;
    }

    public int hashCode() {
        return this.klass.hashCode() * 62 + this.target.hashCode() * 31 + this.source.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Dependency)) {
            return false;
        }
        Dependency d = (Dependency)obj;
        if (!d.klass.equals(this.klass)) {
            return false;
        }
        if (!d.target.equals(this.target)) {
            return false;
        }
        return d.source.equals(this.source);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Dependency: class=").append(this.klass).append(" target=").append(this.target);
        sb.append(" source=").append(this.source);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getMethodOrField(Class<? extends Object> targetClass, boolean tryField) {
        String className = targetClass.getName();
        AccessibleObject obj = null;
        Map<String, AccessibleObject> map = this.cache;
        synchronized (map) {
            obj = this.cache.get(className);
        }
        if (obj != null) {
            return obj;
        }
        Method m = InjectionUtils.findMethodToInject(targetClass, this.target, this.klass);
        if (Debug.isEnabled()) {
            Debug.log(NAME, "Finding method:", "target=", targetClass.getName(), "attrName=", this.target, "sourceClass=", this.klass.getName(), "methodFound=", m == null ? "NULL" : m.getName());
        }
        if (m != null) {
            Map<String, AccessibleObject> map2 = this.cache;
            synchronized (map2) {
                this.cache.put(className, m);
            }
            return m;
        }
        if (tryField) {
            Field f = InjectionUtils.findFieldToInject(targetClass, this.target, this.klass);
            if (Debug.isEnabled()) {
                Debug.log(NAME, "Finding field:", "target=", targetClass.getName(), "attrName=", this.target, "sourceClass=", this.klass.getName(), "fieldFound=", f == null ? "NULL" : f.getName());
            }
            if (f != null) {
                Map<String, AccessibleObject> map3 = this.cache;
                synchronized (map3) {
                    this.cache.put(className, f);
                }
                return f;
            }
        }
        Map<String, AccessibleObject> map4 = this.cache;
        synchronized (map4) {
            this.cache.put(className, null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAlreadyReceived(Object target) {
        Map<Object, Object> map = this.received;
        synchronized (map) {
            return this.received.containsKey(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAlreadyReceived(Object target) {
        Map<Object, Object> map = this.received;
        synchronized (map) {
            this.received.put(target, null);
        }
    }
}

