/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.ioc;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mentawai.ioc.Bean;
import org.mentawai.util.FindMethod;

public class DefaultComponent
implements Bean {
    private Class<? extends Object> klass;
    private Map<String, Object> props = null;
    private List<Object> initValues = null;
    private Constructor<? extends Object> constructor = null;
    private Map<String, AccessibleObject> cache = null;

    public DefaultComponent(Class<? extends Object> klass) {
        this.klass = klass;
    }

    public DefaultComponent(Class<? extends Object> klass, List<Object> initValues) {
        this(klass);
        this.initValues = initValues;
    }

    public DefaultComponent(Class<? extends Object> klass, Map<String, Object> props) {
        this(klass);
        this.props = props;
    }

    public DefaultComponent(Class<? extends Object> klass, List<Object> initValues, Map<String, Object> props) {
        this(klass);
        this.initValues = initValues;
        this.props = props;
    }

    @Override
    public Class<? extends Object> getType() {
        return this.klass;
    }

    public DefaultComponent addProperty(String name, Object value) {
        if (this.props == null) {
            this.props = new HashMap<String, Object>();
            this.cache = new HashMap<String, AccessibleObject>();
        }
        this.props.put(name, value);
        return this;
    }

    public DefaultComponent addProperties(Map map) {
        for (String name : map.keySet()) {
            Object value = map.get(name);
            this.addProperty(name, value);
        }
        return this;
    }

    public DefaultComponent addInitValue(Object value) {
        if (this.initValues == null) {
            this.initValues = new LinkedList<Object>();
        }
        this.initValues.add(value);
        return this;
    }

    public DefaultComponent addInitValues(List values) {
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            this.addInitValue(iter.next());
        }
        return this;
    }

    private Class[] getClasses(List<Object> values) {
        Class[] types = new Class[values.size()];
        Iterator<Object> iter = values.iterator();
        int index = 0;
        while (iter.hasNext()) {
            Object value = iter.next();
            if (value != null) {
                types[index++] = value.getClass();
                continue;
            }
            types[index++] = null;
        }
        return types;
    }

    private Class[] getPrimitiveClasses(List<Object> values) {
        Class[] types = new Class[values.size()];
        Iterator<Object> iter = values.iterator();
        int index = 0;
        while (iter.hasNext()) {
            Object value = iter.next();
            if (value != null) {
                Class p = DefaultComponent.getPrimitiveFrom(value);
                if (p != null) {
                    types[index++] = p;
                    continue;
                }
                types[index++] = value.getClass();
                continue;
            }
            types[index++] = null;
        }
        return types;
    }

    private Object[] getValues(List<Object> values) throws InstantiationException {
        Object[] array = new Object[values.size()];
        int index = 0;
        for (Object obj : values) {
            array[index++] = this.getValue(obj);
        }
        return array;
    }

    private void setValue(Object bean, String name, Object value) throws InstantiationException {
        try {
            AccessibleObject obj;
            Field f;
            StringBuffer sb = new StringBuffer(30);
            sb.append("set");
            sb.append(name.substring(0, 1).toUpperCase());
            if (name.length() > 1) {
                sb.append(name.substring(1));
            }
            String methodName = sb.toString();
            if (!this.cache.containsKey(name)) {
                Method m;
                block15: {
                    m = null;
                    f = null;
                    try {
                        m = FindMethod.getMethod(this.klass, methodName, new Class[]{value.getClass()});
                    }
                    catch (Exception e) {
                        Class primitive = DefaultComponent.getPrimitiveFrom(value);
                        if (primitive != null) {
                            try {
                                m = this.klass.getMethod(methodName, primitive);
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        if (m == null && (f = DefaultComponent.getField(bean, name)) != null) {
                            f.setAccessible(true);
                        }
                        if (m != null || f != null) break block15;
                        throw new InstantiationException("Cannot find method or field for property: " + name);
                    }
                }
                if (m != null) {
                    this.cache.put(name, m);
                    m.setAccessible(true);
                } else {
                    this.cache.put(name, f);
                }
            }
            if ((obj = this.cache.get(name)) instanceof Method) {
                Method m = (Method)obj;
                m.invoke(bean, value);
            } else if (obj instanceof Field) {
                f = (Field)obj;
                f.set(bean, value);
            }
        }
        catch (Exception e) {
            throw new InstantiationException("Error trying to set a property with reflection: " + name);
        }
    }

    static Field getField(Object target, String name) {
        Field[] fields = target.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!name.equals(fields[i].getName())) continue;
            return fields[i];
        }
        return null;
    }

    static Class getPrimitiveFrom(Object w) {
        if (w instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (w instanceof Byte) {
            return Byte.TYPE;
        }
        if (w instanceof Short) {
            return Short.TYPE;
        }
        if (w instanceof Character) {
            return Character.TYPE;
        }
        if (w instanceof Integer) {
            return Integer.TYPE;
        }
        if (w instanceof Long) {
            return Long.TYPE;
        }
        if (w instanceof Float) {
            return Float.TYPE;
        }
        if (w instanceof Double) {
            return Double.TYPE;
        }
        return null;
    }

    private Object getValue(Object obj) throws InstantiationException {
        if (obj instanceof Bean) {
            Bean c = (Bean)obj;
            return c.getBean();
        }
        return obj;
    }

    @Override
    public Object getBean() throws InstantiationException {
        Object obj = null;
        if (this.initValues != null && this.initValues.size() > 0) {
            if (this.constructor == null) {
                try {
                    this.constructor = this.klass.getConstructor(this.getClasses(this.initValues));
                }
                catch (Exception e) {
                    try {
                        this.constructor = this.klass.getConstructor(this.getPrimitiveClasses(this.initValues));
                    }
                    catch (Exception ee) {
                        throw new InstantiationException("Cannot find a constructor for class: " + this.klass);
                    }
                }
            }
            try {
                obj = this.constructor.newInstance(this.getValues(this.initValues));
            }
            catch (Exception e) {
                throw new InstantiationException("Cannot create instance from constructor: " + this.constructor);
            }
        }
        try {
            obj = this.klass.newInstance();
        }
        catch (Exception e) {
            throw new InstantiationException("Cannot create instance from class: " + this.klass);
        }
        if (this.props != null && this.props.size() > 0) {
            for (String name : this.props.keySet()) {
                Object value = this.props.get(name);
                value = this.getValue(value);
                this.setValue(obj, name, value);
            }
        }
        return obj;
    }
}

