/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.i18n;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.mentawai.core.ApplicationManager;
import org.mentawai.filter.ValidatorFilter;
import org.mentawai.list.ListManager;

public class LocaleManager {
    private static String DEFAULT_DIR;
    private static String dir;
    private static List<Locale> locales;
    private static final String SEP;
    private static String master;
    private static boolean useMasterForEverything;
    public static Locale DEFAULT_LOCALE;
    private static String defaultDateMask;
    private static String defaultTimeMask;
    private static Map<Locale, String> dateMasks;
    private static Map<Locale, String> timeMasks;
    private static boolean masterChanged;
    private static boolean usePrefixForActions;
    public static long I18N_RELOAD_TIME;
    public static boolean I18N_DEBUG;
    private static Thread thread;
    private static volatile boolean running;
    private static Set<Locale> dirLocales;
    private static long SCAN_TIME;
    private static boolean wasSetByHand;
    private static final Map<String, SimpleDateFormat> simpleDateFormatters;
    private static final Map<String, SimpleDateFormat> simpleTimeFormatters;

    public static void usePrefixForActions(boolean b) {
        usePrefixForActions = b;
    }

    public static boolean isUsePrefixForActions() {
        return usePrefixForActions;
    }

    private static void initThread() {
        thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (running) {
                    block7: {
                        try {
                            if (!LocaleManager.checkDirs()) {
                                return;
                            }
                        }
                        catch (NullPointerException e) {
                            return;
                        }
                        catch (Throwable e) {
                            if (!running) break block7;
                            e.printStackTrace();
                        }
                    }
                    try {
                        if (!running) continue;
                        Thread.sleep(SCAN_TIME);
                    }
                    catch (Exception exception) {}
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public static void stopLocaleScan() {
        running = false;
        if (thread != null) {
            thread.interrupt();
            try {
                thread.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            thread = null;
        }
    }

    public static void startLocaleScan() {
        if (thread != null) {
            LocaleManager.stopLocaleScan();
        }
        running = true;
        LocaleManager.initThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addLocales(Set<Locale> set) {
        if (set == null || set.isEmpty()) {
            return;
        }
        Set<Locale> set2 = dirLocales;
        synchronized (set2) {
            dirLocales.addAll(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkDirs() throws Throwable {
        if (dirLocales == null) {
            return false;
        }
        Set<Locale> set = dirLocales;
        synchronized (set) {
            dirLocales.clear();
        }
        String master = LocaleManager.getMaster();
        int index = master.lastIndexOf("/");
        if (index > 0) {
            master = master.substring(0, index);
            LocaleManager.addLocales(LocaleManager.scanLocales(master));
        } else {
            LocaleManager.addLocales(LocaleManager.scanLocales(""));
        }
        LocaleManager.addLocales(LocaleManager.scanLocales(LocaleManager.getDir()));
        LocaleManager.addLocales(LocaleManager.scanLocales(ValidatorFilter.getDir()));
        String dir = "/validation".replace('\\', '/');
        if (!ValidatorFilter.getDir().equals(dir)) {
            LocaleManager.addLocales(LocaleManager.scanLocales(dir));
        }
        LocaleManager.addLocales(LocaleManager.scanLocales(ListManager.LIST_DIR.replace('\\', '/')));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Locale checkLocale(Locale loc) {
        if (loc == null) {
            return null;
        }
        Locale first = null;
        Set<Locale> set = dirLocales;
        synchronized (set) {
            for (Locale l : dirLocales) {
                if (first == null) {
                    first = l;
                }
                if (!l.equals(loc)) continue;
                return l;
            }
            for (Locale l : dirLocales) {
                if (!l.getLanguage().equals(loc.getLanguage())) continue;
                return l;
            }
        }
        return first;
    }

    public static Set<Locale> scanLocales(String dir) throws Throwable {
        return LocaleManager.scanLocales(dir, null);
    }

    public static Set<Locale> scanLocales(String dir, String filename) throws Throwable {
        StringBuilder sb = new StringBuilder(128);
        if (ApplicationManager.getRealPath() == null) {
            return null;
        }
        sb.append(ApplicationManager.getRealPath());
        if (dir.startsWith("/") && dir.length() > 1) {
            sb.append(dir);
        } else if (!dir.equals("")) {
            sb.append(File.separator).append(dir);
        }
        File file = new File(sb.toString());
        if (!file.exists() || !file.isDirectory()) {
            return null;
        }
        String[] files = file.list();
        HashSet<Locale> set = new HashSet<Locale>();
        if (filename != null && !filename.endsWith("_")) {
            filename = filename + "_";
        }
        for (int i = 0; i < files.length; ++i) {
            Locale l;
            int lastIndex;
            String[] s;
            int size;
            if (!files[i].endsWith(".i18n") || filename != null && !files[i].startsWith(filename) || (size = (s = files[i].substring(0, lastIndex = files[i].lastIndexOf(".")).split("_")).length) < 2) continue;
            if (size >= 3 && s[size - 1].length() == 2 && s[size - 2].length() == 2) {
                l = new Locale(s[size - 2], s[size - 1]);
                set.add(l);
                continue;
            }
            if (size != 2 || s[size - 1].length() != 2) continue;
            l = new Locale(s[size - 1]);
            set.add(l);
        }
        return set;
    }

    public static void setUseMasterForEverything(boolean useMaster) {
        LocaleManager.useMasterI18N(useMaster);
    }

    public static void useMasterI18N(boolean useMaster) {
        useMasterForEverything = useMaster;
    }

    private static String cutSlashes(String name) {
        if (name.startsWith("/") && name.length() > 1) {
            name = name.substring(1, name.length());
        }
        if (name.endsWith("/") && name.length() > 1) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    public static void setDir(String directory) {
        directory = directory.replace('\\', '/');
        String newDir = LocaleManager.cutSlashes(directory);
        String oldDir = dir;
        if (!masterChanged) {
            master = master.replaceFirst(oldDir, newDir);
        }
        dir = newDir;
    }

    public static String getDir() {
        return dir;
    }

    public static boolean isUseMasterForEverything() {
        return useMasterForEverything;
    }

    public static void add(Locale loc) {
        wasSetByHand = true;
        for (Locale l : locales) {
            if (!l.equals(loc)) continue;
            return;
        }
        locales.add(loc);
    }

    public static void setMaster(String s) {
        masterChanged = true;
        master = s.replace('\\', '/');
        if (master.startsWith("/") && master.length() > 1) {
            master = master.substring(1);
        }
    }

    public static String getMaster() {
        return master;
    }

    public static void add(String loc) {
        Locale l = LocaleManager.getLocaleFromString(loc);
        LocaleManager.add(l);
    }

    public static Locale getDefaultLocale() {
        if (locales.size() == 0) {
            return DEFAULT_LOCALE;
        }
        return locales.get(0);
    }

    public static Locale[] getLocales() {
        Locale[] locs = new Locale[locales.size()];
        locales.toArray(locs);
        return locs;
    }

    public static int[] getLocaleIds() {
        int[] ids = new int[locales.size()];
        for (int i = 0; i < locales.size(); ++i) {
            ids[i] = i;
        }
        return ids;
    }

    public static Locale getLocaleFromString(String text) {
        StringTokenizer st = new StringTokenizer(text, "_");
        if (st.countTokens() == 1) {
            return new Locale(st.nextToken());
        }
        if (st.countTokens() == 2) {
            return new Locale(st.nextToken(), st.nextToken());
        }
        if (st.countTokens() == 3) {
            return new Locale(st.nextToken(), st.nextToken(), st.nextToken());
        }
        return null;
    }

    public static boolean isSupportedLocale(Locale loc) {
        for (Locale l : locales) {
            if (!l.equals(loc)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSupportedLocale(String text) {
        Locale loc = LocaleManager.getLocaleFromString(text);
        if (loc == null) {
            return false;
        }
        return LocaleManager.isSupportedLocale(loc);
    }

    public static Locale getLocale(int id) {
        if (id >= locales.size()) {
            return null;
        }
        return locales.get(id);
    }

    public static int getId(Locale loc) {
        for (int i = 0; i < locales.size(); ++i) {
            if (!locales.get(i).equals(loc)) continue;
            return i;
        }
        return -1;
    }

    public static Locale getSupportedLocale(Locale loc) {
        return LocaleManager.getSupportedLocale(loc, null);
    }

    public static Locale getSupportedLocale(Locale loc, Locale def) {
        Locale autoScan;
        if (LocaleManager.isSupportedLocale(loc)) {
            return loc;
        }
        Locale onlyLang = new Locale(loc.getLanguage());
        for (Locale l : locales) {
            if (!l.equals(onlyLang)) continue;
            return l;
        }
        for (Locale l : locales) {
            if (!l.getLanguage().equals(loc.getLanguage())) continue;
            return l;
        }
        if (!wasSetByHand && (autoScan = LocaleManager.checkLocale(loc)) != null) {
            return autoScan;
        }
        return def != null ? def : LocaleManager.getDefaultLocale();
    }

    public static Locale getLocale(HttpServletRequest req) {
        return LocaleManager.getLocale(req, true);
    }

    public static Locale getLocale(HttpServletRequest req, boolean onlySupported) {
        Locale loc = null;
        HttpSession session = req.getSession(true);
        Object obj = session.getAttribute("sessionLocale");
        loc = obj != null && obj instanceof Locale ? (Locale)obj : req.getLocale();
        if (onlySupported) {
            return LocaleManager.getSupportedLocale(loc);
        }
        return loc;
    }

    public static void setDefaultDateMask(String defaultDateMask) {
        LocaleManager.defaultDateMask = defaultDateMask;
    }

    public static String getDefaultDateMask() {
        return defaultDateMask;
    }

    public static void setDateMask(Locale loc, String dateMask) {
        dateMasks.put(loc, dateMask);
    }

    public static String getDateMask(Locale loc) {
        String s = dateMasks.get(loc);
        if (s == null) {
            return defaultDateMask;
        }
        return s;
    }

    public static void setDefaultTimeMask(String defaultTimeMask) {
        LocaleManager.defaultTimeMask = defaultTimeMask;
    }

    public static String getDefaultTimeMask() {
        return defaultTimeMask;
    }

    public static void setTimeMask(Locale loc, String timeMask) {
        timeMasks.put(loc, timeMask);
    }

    public static String getTimeMask(Locale loc) {
        String s = timeMasks.get(loc);
        if (s == null) {
            return defaultTimeMask;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleDateFormat getSimpleDateFormat(String mask) {
        Map<String, SimpleDateFormat> map = simpleDateFormatters;
        synchronized (map) {
            SimpleDateFormat f = simpleDateFormatters.get(mask);
            if (f != null) {
                return f;
            }
            f = new SimpleDateFormat(mask);
            simpleDateFormatters.put(mask, f);
            return f;
        }
    }

    public static SimpleDateFormat getSimpleDateFormat(Locale loc) {
        String mask = LocaleManager.getDateMask(loc);
        if (mask == null) {
            return null;
        }
        return LocaleManager.getSimpleDateFormat(mask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleDateFormat getSimpleTimeFormat(String mask) {
        Map<String, SimpleDateFormat> map = simpleTimeFormatters;
        synchronized (map) {
            SimpleDateFormat f = simpleTimeFormatters.get(mask);
            if (f != null) {
                return f;
            }
            f = new SimpleDateFormat(mask);
            simpleTimeFormatters.put(mask, f);
            return f;
        }
    }

    public static SimpleDateFormat getSimpleTimeFormat(Locale loc) {
        String mask = LocaleManager.getTimeMask(loc);
        if (mask == null) {
            return null;
        }
        return LocaleManager.getSimpleTimeFormat(mask);
    }

    static {
        dir = DEFAULT_DIR = "i18n";
        locales = new ArrayList<Locale>(20);
        SEP = File.separator;
        master = DEFAULT_DIR + SEP + "master";
        useMasterForEverything = true;
        DEFAULT_LOCALE = new Locale("en", "US");
        defaultDateMask = "MM/dd/yyyy";
        defaultTimeMask = "HH:mm:ss";
        dateMasks = new HashMap<Locale, String>();
        timeMasks = new HashMap<Locale, String>();
        masterChanged = false;
        usePrefixForActions = true;
        I18N_RELOAD_TIME = 30000L;
        I18N_DEBUG = false;
        thread = null;
        dirLocales = new HashSet<Locale>();
        SCAN_TIME = 300000L;
        wasSetByHand = false;
        simpleDateFormatters = new HashMap<String, SimpleDateFormat>();
        LocaleManager.setDateMask(new Locale("en"), "MM/dd/yyyy");
        LocaleManager.setDateMask(new Locale("en", "US"), "MM/dd/yyyy");
        LocaleManager.setDateMask(new Locale("pt"), "dd/MM/yyyy");
        LocaleManager.setDateMask(new Locale("pt", "BR"), "dd/MM/yyyy");
        simpleTimeFormatters = new HashMap<String, SimpleDateFormat>();
        LocaleManager.startLocaleScan();
    }
}

