/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.i18n;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.mentawai.i18n.I18N;
import org.mentawai.i18n.LocaleManager;

class I18NWrapper {
    public static long TIME = LocaleManager.I18N_RELOAD_TIME;
    private long ts = 0L;
    private long lm = 0L;
    private I18N i18n = null;
    private File file = null;
    private String resource = null;

    public I18NWrapper(File file) {
        this.file = file;
    }

    public I18NWrapper(String resource) {
        this.resource = resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadFromFile() {
        FileInputStream fis = null;
        InputStreamReader isr = null;
        try {
            if (!this.file.exists()) {
                this.i18n = null;
                return;
            }
            fis = new FileInputStream(this.file);
            isr = new InputStreamReader((InputStream)fis, I18N.CHARSET);
            Properties prop = new Properties();
            prop.load(isr);
            fis.close();
            this.lm = this.file.lastModified();
            this.i18n = new I18N(prop);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (Exception e) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromClasspath() {
        InputStream is = null;
        InputStreamReader isr = null;
        try {
            is = this.getClass().getResourceAsStream(this.resource);
            isr = new InputStreamReader(is, I18N.CHARSET);
            Properties prop = new Properties();
            prop.load(isr);
            this.i18n = new I18N(prop);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (Exception e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private boolean needsUpdate(boolean check) {
        if (this.resource != null) {
            return this.i18n == null;
        }
        long ctm = System.currentTimeMillis();
        if (check) {
            if (ctm - this.ts > TIME) {
                this.ts = ctm;
            } else {
                return false;
            }
        }
        return this.i18n == null || this.file.lastModified() != this.lm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I18N getI18N() {
        if (this.needsUpdate(true)) {
            File file = this.file;
            synchronized (file) {
                if (this.needsUpdate(false)) {
                    if (this.resource != null) {
                        this.loadFromClasspath();
                    } else {
                        this.reloadFromFile();
                    }
                }
            }
        }
        return this.i18n;
    }
}

