/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.i18n;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.mentawai.i18n.I18N;

public class I18NHolder {
    private Map<Locale, I18N> map = new HashMap<Locale, I18N>();

    public void clear() {
        this.map.clear();
    }

    public boolean containsLocale(Locale loc) {
        return this.map.containsKey(loc);
    }

    public boolean containsI18n(I18N i18n) {
        return this.map.containsValue(i18n);
    }

    public I18N get(Locale loc) {
        I18N i18n = this.map.get(loc);
        if (i18n != null) {
            return i18n;
        }
        return new EmptyI18n();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public List<Locale> locales() {
        return new ArrayList<Locale>(this.map.keySet());
    }

    public I18N add(Locale loc, I18N i18n) {
        return this.map.put(loc, i18n);
    }

    public void putAll(Map<? extends Locale, ? extends I18N> map) {
        this.map.putAll(map);
    }

    public I18N remove(Locale loc) {
        return this.map.remove(loc);
    }

    public int size() {
        return this.map.size();
    }

    private class EmptyI18n
    extends I18N {
        public EmptyI18n() {
            super(null);
        }

        @Override
        public String get(int key) {
            return this.get(String.valueOf(key));
        }

        @Override
        public boolean hasKey(String key) {
            return false;
        }

        @Override
        public String get(String key) {
            return '!' + key + '!';
        }

        @Override
        public Iterator<String> keys() {
            return new ArrayList().iterator();
        }
    }
}

