/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.formatter;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.mentawai.formatter.Formatter;

public class NumberFormatter
implements Formatter {
    private int style = -1;
    private String pattern = null;
    private DecimalFormatSymbols symbols;
    public static final int INTEGER = 0;
    public static final int REAL = 1;
    public static final int PERCENTAGE = 2;
    public static final int CURRENCY = 3;

    public NumberFormatter(int style) {
        this.style = style;
    }

    public NumberFormatter(String pattern) {
        this(pattern, new DecimalFormatSymbols(Locale.getDefault()));
    }

    public NumberFormatter(String pattern, DecimalFormatSymbols symbols) {
        this.pattern = pattern;
        this.symbols = symbols;
    }

    @Override
    public String format(Object value, Locale loc) {
        NumberFormat nf;
        Number n;
        block8: {
            block9: {
                block7: {
                    if (!(value instanceof Number)) {
                        return value.toString();
                    }
                    n = (Number)value;
                    if (this.pattern == null) break block7;
                    nf = new DecimalFormat(this.pattern, this.symbols);
                    break block8;
                }
                if (this.style == -1) break block9;
                switch (this.style) {
                    case 0: {
                        nf = NumberFormat.getIntegerInstance(loc);
                        break block8;
                    }
                    case 1: {
                        nf = NumberFormat.getNumberInstance(loc);
                        break block8;
                    }
                    case 2: {
                        nf = NumberFormat.getPercentInstance(loc);
                        break block8;
                    }
                    case 3: {
                        nf = NumberFormat.getCurrencyInstance(loc);
                        break block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid Style number: " + this.style);
                    }
                }
            }
            throw new IllegalStateException("Should never be here!");
        }
        return nf.format(n);
    }
}

