/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.formatter;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.mentawai.formatter.Formatter;

public class DateFormatter
implements Formatter {
    private int style = -1;
    private SimpleDateFormat sdf = null;

    public DateFormatter(int style) {
        this.style = style;
    }

    public DateFormatter(String pattern) {
        this.sdf = new SimpleDateFormat(pattern);
    }

    @Override
    public String format(Object value, Locale loc) {
        if (!(value instanceof Date)) {
            return value.toString();
        }
        Date d = (Date)value;
        if (this.sdf != null) {
            return this.sdf.format(d);
        }
        if (this.style != -1) {
            DateFormat df = DateFormat.getDateInstance(this.style, loc);
            return df.format(d);
        }
        throw new IllegalStateException("Should never be here!");
    }
}

