/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mentawai.core.Action;
import org.mentawai.core.Filter;
import org.mentawai.core.InvocationChain;
import org.mentawai.i18n.LocaleManager;
import org.mentawai.jruby.JRubyInterpreter;
import org.mentawai.jruby.RubyAction;
import org.mentawai.message.ClassMessageContext;
import org.mentawai.message.FileMessageContext;
import org.mentawai.message.MessageContext;
import org.mentawai.util.FindMethod;
import org.mentawai.validation.Validatable;
import org.mentawai.validation.Validator;

public class ValidatorFilter
implements Filter {
    private static final String DEFAULT_DIR = "/validation";
    private String resultForError = "error";
    private Map<ActionUniqueId, MessageContext> msgContexts = new Hashtable<ActionUniqueId, MessageContext>();
    private String dir = "/validation";
    private static String DIR = "/validation";

    public ValidatorFilter() {
    }

    public ValidatorFilter(String resultForError) {
        this();
        this.resultForError = resultForError;
    }

    public static String getDir() {
        return DIR;
    }

    private MessageContext getMessageContext(Class<? extends Object> klass) {
        FileMessageContext masterMsgContext = null;
        if (LocaleManager.isUseMasterForEverything()) {
            masterMsgContext = new FileMessageContext(LocaleManager.getMaster(), "");
            if (LocaleManager.isUsePrefixForActions()) {
                String prefix = klass.getSimpleName();
                masterMsgContext.setPrefix(prefix);
            }
            return masterMsgContext;
        }
        return new ClassMessageContext(klass, this.dir);
    }

    public void setResultForError(String resultForError) {
        this.resultForError = resultForError;
    }

    public void setDir(String dir) {
        this.dir = dir.replace('\\', '/');
        DIR = dir;
        this.msgContexts.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String filter(InvocationChain chain) throws Exception {
        Action action = chain.getAction();
        Object pojo = chain.getPojo();
        Object actionImpl = pojo != null ? pojo : action;
        Validator validator = null;
        ActionUniqueId actionId = null;
        if (actionImpl instanceof Validatable) {
            actionId = new ActionUniqueId(actionImpl.getClass().getName(), chain.getInnerAction());
            Validatable v = (Validatable)actionImpl;
            validator = new Validator(new LinkedHashMap<String, Object>(), new HashMap<String, Object>());
            v.prepareValidator(validator, chain.getInnerAction());
        } else {
            if (!(action instanceof RubyAction)) return chain.invoke();
            RubyAction ra = (RubyAction)action;
            JRubyInterpreter ruby = JRubyInterpreter.getInstance();
            if (!ruby.respondTo(ra.getRubyObject(), "prepareValidator")) return chain.invoke();
            validator = new Validator(new LinkedHashMap<String, Object>(), new HashMap<String, Object>());
            actionId = new ActionUniqueId(ra.getActionName(), chain.getInnerAction());
            ruby.call(ra.getRubyObject(), "prepareValidator", validator, chain.getInnerAction());
        }
        MessageContext msgContext = this.msgContexts.get(actionId);
        if (msgContext == null) {
            msgContext = this.getMessageContext(actionImpl.getClass());
            this.msgContexts.put(actionId, msgContext);
        }
        boolean isOk = validator.validate(action, msgContext);
        if (actionImpl instanceof Validatable) {
            Method m = null;
            try {
                m = FindMethod.getDeclaredMethod(actionImpl.getClass(), "afterValidation", new Class[]{Boolean.TYPE, String.class});
            }
            catch (Exception e) {
                // empty catch block
            }
            if (m != null) {
                m.invoke(actionImpl, isOk, chain.getInnerAction());
            }
        }
        if (isOk) return chain.invoke();
        return this.resultForError;
    }

    @Override
    public void destroy() {
    }

    static class ActionUniqueId {
        String classname;
        String innerAction = null;

        public ActionUniqueId(String classname, String innerAction) {
            this.classname = classname;
            this.innerAction = innerAction;
        }

        public int hashCode() {
            return 34544 * this.classname.hashCode() + 194 * (this.innerAction == null ? 0 : this.innerAction.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj instanceof ActionUniqueId) {
                ActionUniqueId a = (ActionUniqueId)obj;
                if (a.classname.equals(this.classname)) {
                    if (a.innerAction == null && this.innerAction == null) {
                        return true;
                    }
                    if (a.innerAction != null && this.innerAction != null && a.innerAction.equals(this.innerAction)) {
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

