/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.util.HashMap;
import java.util.LinkedHashMap;
import org.mentawai.core.Action;
import org.mentawai.core.Filter;
import org.mentawai.core.Input;
import org.mentawai.core.InvocationChain;
import org.mentawai.i18n.LocaleManager;
import org.mentawai.message.ClassMessageContext;
import org.mentawai.message.FileMessageContext;
import org.mentawai.message.MessageContext;
import org.mentawai.validation.Validator;

public abstract class ValidationFilter
implements Filter {
    public static final String DEFAULT_DIR = "/validation";
    private String resultForError = "error";
    private MessageContext msgContext = LocaleManager.isUseMasterForEverything() ? new FileMessageContext(LocaleManager.getMaster(), "") : new ClassMessageContext(this.getClass(), "/validation".replace('\\', '/'));

    private Validator getValidator(Action action, String innerAction) {
        LinkedHashMap<String, Object> rules = new LinkedHashMap<String, Object>();
        HashMap<String, Object> errors = new HashMap<String, Object>();
        Validator validator = new Validator(rules, errors);
        this.prepareValidator(validator, action, innerAction);
        return validator;
    }

    public abstract void prepareValidator(Validator var1, Action var2, String var3);

    public void setResultForError(String resultForError) {
        this.resultForError = resultForError;
    }

    public void setMessageContext(MessageContext msgContext) {
        this.msgContext = msgContext;
    }

    public static boolean isPost(Action action) {
        Input input = action.getInput();
        String method = input.getProperty("method");
        return method != null && method.equalsIgnoreCase("post");
    }

    public void setDir(String dir) {
        this.msgContext = new ClassMessageContext(this.getClass(), dir);
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Action action = chain.getAction();
        Validator validator = this.getValidator(action, chain.getInnerAction());
        boolean isOk = validator.validate(action, this.msgContext);
        if (!isOk) {
            return this.resultForError;
        }
        return chain.invoke();
    }

    @Override
    public void destroy() {
    }
}

