/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.util.HashSet;
import java.util.Set;
import org.mentawai.core.Action;
import org.mentawai.core.Filter;
import org.mentawai.core.FilterException;
import org.mentawai.core.Input;
import org.mentawai.core.InvocationChain;
import org.mentawai.log.Debug;
import org.mentawai.transaction.Transaction;

public class TransactionFilter
implements Filter {
    private static final String NAME = "TransactionFilter";
    public static String TRANSACTION_KEY = "transaction";
    private static final boolean ONLY_POST = false;
    private final String transactionKey;
    private Set<String> resultsForRollback = new HashSet<String>();
    private Set<String> resultsForCommit = new HashSet<String>();
    private final boolean onlyPost;

    public TransactionFilter() {
        this(TRANSACTION_KEY, false);
    }

    public TransactionFilter(boolean onlyPost) {
        this(TRANSACTION_KEY, onlyPost);
    }

    public TransactionFilter(String transaction_key) {
        this(transaction_key, false);
    }

    public TransactionFilter(String transaction_key, boolean onlyPost) {
        this.transactionKey = transaction_key;
        this.onlyPost = onlyPost;
        this.resultsForCommit.add("success");
        this.resultsForRollback.add("error");
    }

    public TransactionFilter commitOn(String ... results) {
        for (String result : results) {
            if (this.resultsForRollback.contains(result)) {
                this.resultsForRollback.remove(result);
            }
            this.resultsForCommit.add(result);
        }
        return this;
    }

    public TransactionFilter rollbackOn(String ... results) {
        for (String result : results) {
            if (this.resultsForCommit.contains(result)) {
                this.resultsForCommit.remove(result);
            }
            this.resultsForRollback.add(result);
        }
        return this;
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Transaction transaction;
        Action action = chain.getAction();
        Input input = action.getInput();
        if (this.onlyPost) {
            boolean isPost;
            String method = input.getProperty("method");
            boolean bl = isPost = method != null && method.equalsIgnoreCase("post");
            if (!isPost) {
                return chain.invoke();
            }
        }
        if ((transaction = (Transaction)input.getValue(this.transactionKey)) == null) {
            if (Debug.isEnabled()) {
                Debug.log(NAME, "Transaction was NULL inside TransactionFilter!!!");
            }
            throw new FilterException("Cannot find transaction in action's input with the given key: " + this.transactionKey);
        }
        try {
            if (Debug.isEnabled()) {
                Debug.log(NAME, "Beginning transaction...");
            }
            transaction.begin();
            if (Debug.isEnabled()) {
                Debug.log(NAME, "Transaction was begun! Will invoke action...");
            }
            String result = chain.invoke();
            boolean shouldRollback = this.resultsForRollback.contains(result);
            boolean shouldCommit = this.resultsForCommit.contains(result);
            if (shouldCommit || !shouldCommit && !shouldRollback) {
                if (Debug.isEnabled()) {
                    Debug.log(NAME, "Result was ok! Will commit the transaction...", "Result =", result);
                }
                transaction.commit();
                if (Debug.isEnabled()) {
                    Debug.log(NAME, "Transaction was committed!");
                }
            } else {
                if (Debug.isEnabled()) {
                    Debug.log(NAME, "Result was not ok! Will rollback the transaction...", "Result =", result);
                }
                transaction.rollback();
                if (Debug.isEnabled()) {
                    Debug.log(NAME, "Transaction was rolled back!");
                }
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (Debug.isEnabled()) {
                Debug.log(NAME, "An exception was thrown while executing action! Will try to rollback...", "msg =", e.getMessage());
            }
            transaction.rollback();
            if (Debug.isEnabled()) {
                Debug.log(NAME, "Transaction was rolled back!");
            }
            throw e;
        }
    }

    public Set<String> getResultsForCommit() {
        return this.resultsForCommit;
    }

    public Set<String> getResultsForRollback() {
        return this.resultsForRollback;
    }

    @Override
    public void destroy() {
    }
}

