/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.mentawai.core.Action;
import org.mentawai.core.Filter;
import org.mentawai.core.Input;
import org.mentawai.core.InvocationChain;
import org.mentawai.filter.PushInjectionFilter;
import org.mentawai.util.FindMethod;

public class PushVOFilter
implements Filter {
    private Class<? extends Object> klass;
    private String key = null;
    private Map<String, AccessibleObject> cache = Collections.synchronizedMap(new HashMap());
    private Map<String, AccessibleObject> cacheConverted = Collections.synchronizedMap(new HashMap());
    private boolean tryField = true;
    private String prefix = null;
    private boolean convert = true;

    public PushVOFilter(Class<? extends Object> klass) {
        this.klass = klass;
    }

    public PushVOFilter(Class klass, boolean tryField) {
        this(klass);
        this.tryField = tryField;
    }

    public PushVOFilter(Class klass, String key) {
        this(klass);
        this.key = key;
    }

    public PushVOFilter(Class klass, String key, boolean tryField) {
        this(klass, key);
        this.tryField = tryField;
    }

    public PushVOFilter(Class klass, String key, boolean tryField, String prefix) {
        this(klass, key, tryField);
        this.prefix = prefix;
    }

    public PushVOFilter(Class klass, String key, boolean tryField, boolean convert, String prefix) {
        this(klass, key, tryField);
        this.prefix = prefix;
        this.convert = convert;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("PushVOFilter: Class=").append(this.klass.getName()).append(" Key=").append(this.key != null ? this.key : this.klass.getName());
        sb.append(" TryField=").append(this.tryField);
        return sb.toString();
    }

    private Object createObject() {
        try {
            return this.klass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean setValueByReflection(Object bean, String name, Object value, Locale loc, boolean converted) {
        try {
            AccessibleObject obj;
            Field f;
            StringBuffer sb = new StringBuffer(30);
            sb.append("set");
            sb.append(name.substring(0, 1).toUpperCase());
            if (name.length() > 1) {
                sb.append(name.substring(1));
            }
            String methodName = sb.toString();
            Map<String, AccessibleObject> cache = null;
            cache = converted ? this.cacheConverted : this.cache;
            if (!cache.containsKey(name)) {
                Method m;
                block13: {
                    m = null;
                    f = null;
                    try {
                        m = FindMethod.getMethod(this.klass, methodName, new Class[]{value.getClass()});
                    }
                    catch (Exception e) {
                        Class primitive = PushInjectionFilter.getPrimitiveFrom(value);
                        if (primitive != null) {
                            try {
                                m = this.klass.getMethod(methodName, primitive);
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        if (m != null || !this.tryField || (f = PushInjectionFilter.getField(bean, name)) == null) break block13;
                        f.setAccessible(true);
                    }
                }
                if (m != null) {
                    cache.put(name, m);
                    m.setAccessible(true);
                } else {
                    cache.put(name, f);
                }
            }
            if ((obj = cache.get(name)) instanceof Method) {
                Method m = (Method)obj;
                m.invoke(bean, value);
                return true;
            }
            if (obj instanceof Field) {
                f = (Field)obj;
                f.set(bean, value);
                return true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Action action = chain.getAction();
        Input input = action.getInput();
        Object bean = this.createObject();
        if (bean != null) {
            Iterator<String> iter = input.keys();
            while (iter.hasNext()) {
                Object value;
                String name;
                String beanName = name = iter.next();
                if (this.prefix != null) {
                    String[] s;
                    if (!name.startsWith(this.prefix) || (s = name.split("\\.")).length != 2 || !s[0].equals(this.prefix)) continue;
                    beanName = s[1];
                }
                if ((value = input.getValue(name)) == null) continue;
                this.setValue(bean, beanName, value, action.getLocale());
            }
            if (this.key != null) {
                input.setValue(this.key, bean);
            } else {
                input.setValue(this.klass.getName(), bean);
            }
        }
        return chain.invoke();
    }

    protected Object getConvertedValue(String className, String value, Locale loc) {
        Comparable<Integer> newValue = null;
        if (className.equals("int") || className.equals("java.lang.Integer")) {
            int x = -1;
            try {
                x = Integer.parseInt(value);
            }
            catch (Exception e) {
                return null;
            }
            newValue = new Integer(x);
        } else if (className.equals("double") || className.equals("java.lang.Double")) {
            double x = -1.0;
            try {
                x = Double.parseDouble(value);
            }
            catch (Exception e) {
                return null;
            }
            newValue = new Double(x);
        } else if (className.equals("boolean") || className.equals("java.lang.Boolean")) {
            try {
                int x = Integer.parseInt(value);
                if (x == 1) {
                    newValue = Boolean.TRUE;
                }
                if (x == 0) {
                    newValue = Boolean.FALSE;
                }
                return null;
            }
            catch (Exception e) {
                if (value.equalsIgnoreCase("true") || value.equals("on")) {
                    newValue = Boolean.TRUE;
                }
                if (value.equalsIgnoreCase("false")) {
                    newValue = Boolean.FALSE;
                }
                return null;
            }
        } else if (className.equals("java.util.Date")) {
            DateFormat df = DateFormat.getDateInstance(3, loc);
            df.setLenient(false);
            try {
                newValue = df.parse(value);
            }
            catch (Exception e) {
                return null;
            }
        }
        return newValue;
    }

    protected boolean setValue(Object bean, String name, Object value, Locale loc) {
        Field f;
        boolean ok = this.setValueByReflection(bean, name, value, loc, false);
        if (this.convert && !ok && value != null && value instanceof String && (f = PushInjectionFilter.getField(bean, name)) != null) {
            f.setAccessible(true);
            Object converted = this.getConvertedValue(f.getType().getName(), (String)value, loc);
            if (converted != null) {
                ok = this.setValueByReflection(bean, name, converted, loc, true);
            }
        }
        return ok;
    }

    @Override
    public void destroy() {
    }
}

