/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import org.mentawai.core.Action;
import org.mentawai.core.Context;
import org.mentawai.core.Filter;
import org.mentawai.core.FilterException;
import org.mentawai.core.Input;
import org.mentawai.core.InvocationChain;
import org.mentawai.ioc.Bean;

public class PushIoCFilter
implements Filter {
    public static final int ACTION = 10;
    public static final int REQUEST = 11;
    public static final int SESSION = 3;
    public static final int APPLICATION = 4;
    private Bean comp;
    private int scope = 10;
    private String key;

    public PushIoCFilter(Bean comp, String key) {
        this.comp = comp;
        this.key = key;
    }

    public PushIoCFilter(Bean comp, String key, int scope) {
        this(comp, key);
        this.scope = scope;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("PushIoCFilter: Component=").append(this.comp).append(" Key=").append(this.key).append(" Scope=");
        sb.append(this.getScope(this.scope));
        return sb.toString();
    }

    private String getScope(int scope) {
        switch (scope) {
            case 10: {
                return "ACTION";
            }
            case 11: {
                return "REQUEST";
            }
            case 3: {
                return "SESSION";
            }
            case 4: {
                return "APPLICATION";
            }
        }
        return "?";
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        block9: {
            Action action = chain.getAction();
            Input input = action.getInput();
            Context session = action.getSession();
            Context application = action.getApplication();
            try {
                if (this.scope == 4) {
                    Object obj = application.getAttribute(this.key);
                    if (obj == null) {
                        obj = this.comp.getBean();
                        application.setAttribute(this.key, obj);
                    }
                    input.setValue(this.key, obj);
                    break block9;
                }
                if (this.scope == 3) {
                    Object obj = session.getAttribute(this.key);
                    if (obj == null) {
                        obj = this.comp.getBean();
                        session.setAttribute(this.key, obj);
                    }
                    input.setValue(this.key, obj);
                    break block9;
                }
                if (this.scope == 11) {
                    Object obj = input.getValue(this.key);
                    if (obj == null) {
                        obj = this.comp.getBean();
                        input.setValue(this.key, obj);
                    }
                    break block9;
                }
                if (this.scope == 10) {
                    input.setValue(this.key, this.comp.getBean());
                    break block9;
                }
                throw new FilterException("Invalid scope for IoCFilter: " + this.scope);
            }
            catch (InstantiationException e) {
                throw new FilterException(e);
            }
        }
        return chain.invoke();
    }

    @Override
    public void destroy() {
    }
}

