/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.mentawai.core.Action;
import org.mentawai.core.Filter;
import org.mentawai.core.FilterException;
import org.mentawai.core.Input;
import org.mentawai.core.InvocationChain;
import org.mentawai.core.PojoAction;
import org.mentawai.filter.ModelDriven;
import org.mentawai.util.FindMethod;

public class PushInjectionFilter
implements Filter {
    private Map<Class, Map> methods = Collections.synchronizedMap(new HashMap());
    private Map<Class, Map> methodsConverted = Collections.synchronizedMap(new HashMap());
    private boolean tryField = true;
    private boolean convert = true;

    public PushInjectionFilter() {
    }

    public PushInjectionFilter(boolean tryField) {
        this.tryField = tryField;
    }

    public PushInjectionFilter(boolean tryField, boolean convert) {
        this(tryField);
        this.convert = convert;
    }

    static Field getField(Object target, String name) {
        Field[] fields = target.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!name.equals(fields[i].getName())) continue;
            return fields[i];
        }
        return null;
    }

    private boolean setValueByReflection(Object target, String name, Object value, Locale loc, boolean converted) {
        try {
            Object obj;
            Field f;
            StringBuffer sb = new StringBuffer(30);
            sb.append("set");
            sb.append(name.substring(0, 1).toUpperCase());
            if (name.length() > 1) {
                sb.append(name.substring(1));
            }
            String methodName = sb.toString();
            Class<?> actionClass = target.getClass();
            Map<Class, Map> methods = null;
            methods = converted ? this.methodsConverted : this.methods;
            HashMap<String, AccessibleObject> map = methods.get(actionClass);
            if (map == null) {
                map = new HashMap<String, AccessibleObject>();
                methods.put(actionClass, map);
            }
            if (!map.containsKey(name)) {
                Method m;
                block14: {
                    m = null;
                    f = null;
                    try {
                        m = FindMethod.getMethod(actionClass, methodName, new Class[]{value.getClass()});
                    }
                    catch (Exception e) {
                        Class primitive = PushInjectionFilter.getPrimitiveFrom(value);
                        if (primitive != null) {
                            try {
                                m = actionClass.getMethod(methodName, primitive);
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        if (m != null || !this.tryField || (f = PushInjectionFilter.getField(target, name)) == null) break block14;
                        f.setAccessible(true);
                    }
                }
                if (m != null) {
                    map.put(name, m);
                    m.setAccessible(true);
                } else {
                    map.put(name, f);
                }
            }
            if ((obj = map.get(name)) instanceof Method) {
                Method m = (Method)obj;
                m.invoke(target, value);
                return true;
            }
            if (obj instanceof Field) {
                f = (Field)obj;
                f.set(target, value);
                return true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    protected Object getConvertedValue(String className, String value, Locale loc) {
        Comparable<Integer> newValue = null;
        if (className.equals("int") || className.equals("java.lang.Integer")) {
            int x = -1;
            try {
                x = Integer.parseInt(value);
            }
            catch (Exception e) {
                return null;
            }
            newValue = new Integer(x);
        } else if (className.equals("double") || className.equals("java.lang.Double")) {
            double x = -1.0;
            try {
                x = Double.parseDouble(value);
            }
            catch (Exception e) {
                return null;
            }
            newValue = new Double(x);
        } else if (className.equals("boolean") || className.equals("java.lang.Boolean")) {
            try {
                int x = Integer.parseInt(value);
                if (x == 1) {
                    newValue = Boolean.TRUE;
                }
                if (x == 0) {
                    newValue = Boolean.FALSE;
                }
                return null;
            }
            catch (Exception e) {
                if (value.equalsIgnoreCase("true") || value.equals("on")) {
                    newValue = Boolean.TRUE;
                }
                if (value.equalsIgnoreCase("false")) {
                    newValue = Boolean.FALSE;
                }
                return null;
            }
        } else if (className.equals("java.util.Date")) {
            DateFormat df = DateFormat.getDateInstance(3, loc);
            df.setLenient(false);
            try {
                newValue = df.parse(value);
            }
            catch (Exception e) {
                return null;
            }
        }
        return newValue;
    }

    protected boolean setValue(Object target, String name, Object value, Locale loc) {
        Field f;
        boolean ok = this.setValueByReflection(target, name, value, loc, false);
        if (this.convert && !ok && value != null && value instanceof String && (f = PushInjectionFilter.getField(target, name)) != null) {
            f.setAccessible(true);
            Object converted = this.getConvertedValue(f.getType().getName(), (String)value, loc);
            if (converted != null) {
                ok = this.setValueByReflection(target, name, converted, loc, true);
            }
        }
        return ok;
    }

    static Class getPrimitiveFrom(Object w) {
        if (w instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (w instanceof Byte) {
            return Byte.TYPE;
        }
        if (w instanceof Short) {
            return Short.TYPE;
        }
        if (w instanceof Character) {
            return Character.TYPE;
        }
        if (w instanceof Integer) {
            return Integer.TYPE;
        }
        if (w instanceof Long) {
            return Long.TYPE;
        }
        if (w instanceof Float) {
            return Float.TYPE;
        }
        if (w instanceof Double) {
            return Double.TYPE;
        }
        return null;
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Action action = chain.getAction();
        Object model = null;
        Object pojo = null;
        if (action instanceof ModelDriven) {
            ModelDriven md = (ModelDriven)((Object)action);
            model = md.getModel();
            if (model == null) {
                throw new FilterException("ModelDriven action cannot return a null model!");
            }
        } else if (action instanceof PojoAction) {
            PojoAction pa = (PojoAction)action;
            pojo = pa.getPojo();
        }
        Input input = action.getInput();
        Iterator<String> iter = input.keys();
        while (iter.hasNext()) {
            String name = iter.next();
            Object value = input.getValue(name);
            if (value == null) continue;
            if (model != null) {
                this.setValue(model, name, value, action.getLocale());
                continue;
            }
            if (pojo != null) {
                this.setValue(pojo, name, value, action.getLocale());
                continue;
            }
            this.setValue(action, name, value, action.getLocale());
        }
        return chain.invoke();
    }

    @Override
    public void destroy() {
    }
}

