/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.sql.Connection;
import java.sql.SQLException;
import org.mentawai.core.Action;
import org.mentawai.core.Filter;
import org.mentawai.core.FilterException;
import org.mentawai.core.Input;
import org.mentawai.core.InvocationChain;
import org.mentawai.db.ConnectionHandler;

public class PushConnectionFilter
implements Filter {
    public static final String KEY = "conn";
    private ConnectionHandler connHandler;
    private String conn_key = "conn";

    public PushConnectionFilter(ConnectionHandler connHandler) {
        this.connHandler = connHandler;
    }

    public PushConnectionFilter(ConnectionHandler connHandler, String conn_key) {
        this(connHandler);
        this.conn_key = conn_key;
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Action action = chain.getAction();
        Input input = action.getInput();
        Connection conn = null;
        try {
            conn = this.connHandler.getConnection();
            input.setValue(this.conn_key, conn);
            String string = chain.invoke();
            return string;
        }
        catch (SQLException e) {
            throw new FilterException(e);
        }
        finally {
            input.removeValue(this.conn_key);
            this.connHandler.release(conn);
        }
    }

    @Override
    public void destroy() {
    }
}

