/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.util.Collection;
import org.mentawai.core.Action;
import org.mentawai.core.Filter;
import org.mentawai.core.Input;
import org.mentawai.core.InvocationChain;
import org.mentawai.core.Output;
import org.mentawai.filter.Paginator;

public class PaginatorFilter
implements Filter {
    public static final String DEFAULT_PAGE_PARAM = "p";
    public static final int DEFAULT_ITEMS_PER_PAGE = 20;
    private int itemsPerPage;
    private String key;
    private String pageParam;

    public PaginatorFilter(String key) {
        this(key, 20, DEFAULT_PAGE_PARAM);
    }

    public PaginatorFilter(String key, int itemsPerPage) {
        this(key, itemsPerPage, DEFAULT_PAGE_PARAM);
    }

    public PaginatorFilter(String key, int itemsPerPage, String pageParam) {
        this.key = key;
        this.itemsPerPage = itemsPerPage;
        this.pageParam = pageParam;
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Action action = chain.getAction();
        String result = chain.invoke();
        Output output = action.getOutput();
        Object value = output.getValue(this.key);
        if (value != null) {
            int endIndex;
            int startIndex;
            Object[] arr;
            if (value.getClass().isArray()) {
                arr = (Object[])value;
            } else if (value instanceof Collection) {
                Collection coll = (Collection)value;
                arr = coll.toArray();
            } else {
                return result;
            }
            Input input = action.getInput();
            int page = input.getInt(this.pageParam);
            if (page <= 0) {
                page = 1;
            }
            if ((startIndex = (page - 1) * this.itemsPerPage) >= arr.length) {
                startIndex = 0;
            }
            if ((endIndex = startIndex + this.itemsPerPage) > arr.length) {
                endIndex = arr.length;
            }
            Object[] newArr = PaginatorFilter.copyOfRange(arr, startIndex, endIndex);
            int currentPage = startIndex / this.itemsPerPage + 1;
            int lastPage = arr.length % this.itemsPerPage == 0 ? arr.length / this.itemsPerPage : arr.length / this.itemsPerPage + 1;
            Paginator p = new Paginator(newArr, currentPage, lastPage, this.itemsPerPage, arr.length);
            output.setValue(this.key, p);
        }
        return result;
    }

    public static Object[] copyOfRange(Object[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        Object[] copy = new Object[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    @Override
    public void destroy() {
    }
}

