/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

public class Paginator {
    private Object[] data;
    private int currentPage;
    private int lastPage;
    private int itemsPerPage;
    private int count;

    Paginator() {
    }

    Paginator(Object[] data, int currentPage, int lastPage, int itemsPerPage, int count) {
        this.data = data;
        this.currentPage = currentPage;
        this.lastPage = lastPage;
        this.itemsPerPage = itemsPerPage;
        this.count = count;
    }

    public boolean hasNext() {
        return this.currentPage != this.lastPage;
    }

    public boolean hasPrevious() {
        return this.currentPage > 1;
    }

    public int getNextPage() {
        if (this.hasNext()) {
            return this.currentPage + 1;
        }
        return this.lastPage;
    }

    public int getPreviousPage() {
        if (this.hasPrevious()) {
            return this.currentPage - 1;
        }
        return 1;
    }

    public void setData(Object[] data) {
        this.data = data;
    }

    public Object[] getData() {
        return this.data;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setMaxPage(int maxPage) {
        this.lastPage = maxPage;
    }

    public int getMaxPage() {
        return this.lastPage;
    }

    public void setItemsPerPage(int itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public int getNumberOfItems() {
        if (this.data != null) {
            return this.data.length;
        }
        return 0;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }
}

