/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.lang.reflect.Method;
import org.mentawai.core.Action;
import org.mentawai.core.Filter;
import org.mentawai.core.InputWrapper;
import org.mentawai.core.InvocationChain;
import org.mentawai.core.Output;
import org.mentawai.core.PojoAction;
import org.mentawai.filter.ModelDriven;

public class OutputFilter
extends InputWrapper
implements Filter {
    private String name = null;
    private ThreadLocal<Action> action = new ThreadLocal();

    public OutputFilter() {
    }

    public OutputFilter(String name) {
        this.name = name;
    }

    public boolean isNewVersion() {
        return this.name != null;
    }

    private String filterNew(InvocationChain chain) throws Exception {
        Action action = chain.getAction();
        super.setInput(action.getInput());
        action.setInput(this);
        this.action.set(action);
        return chain.invoke();
    }

    @Override
    public Object getValue(String name) {
        if (name.equals(this.name)) {
            Object value = super.getValue(name);
            if (value != null) {
                return value;
            }
            Action action = this.action.get();
            if (action == null) {
                throw new IllegalStateException("Action cannot be null here!");
            }
            Output output = action.getOutput();
            this.setValue(name, output);
            return output;
        }
        return super.getValue(name);
    }

    private String adjustName(String name) {
        StringBuffer sb = new StringBuffer(name.length() - 3);
        sb.append(name.substring(3, 4).toLowerCase());
        sb.append(name.substring(4, name.length()));
        return sb.toString();
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        if (this.name != null) {
            return this.filterNew(chain);
        }
        String result = chain.invoke();
        Action action = chain.getAction();
        Output output = action.getOutput();
        boolean isModelDriven = false;
        boolean isPojoAction = false;
        if (action instanceof ModelDriven) {
            isModelDriven = true;
        } else if (action instanceof PojoAction) {
            isPojoAction = true;
        }
        Method[] methods = null;
        if (isModelDriven) {
            ModelDriven md = (ModelDriven)((Object)action);
            methods = md.getModel().getClass().getMethods();
        } else if (isPojoAction) {
            PojoAction pa = (PojoAction)action;
            methods = pa.getPojo().getClass().getMethods();
        } else {
            methods = action.getClass().getDeclaredMethods();
        }
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if (name.length() <= 3 || !name.startsWith("get") || methods[i].getParameterTypes().length != 0 || name.equals("getClass")) continue;
            try {
                methods[i].setAccessible(true);
                Object value = null;
                if (isModelDriven) {
                    ModelDriven md = (ModelDriven)((Object)action);
                    value = methods[i].invoke(md.getModel(), (Object[])null);
                } else if (isPojoAction) {
                    PojoAction pa = (PojoAction)action;
                    value = methods[i].invoke(pa.getPojo(), (Object[])null);
                } else {
                    value = methods[i].invoke((Object)action, new Object[0]);
                }
                output.setValue(this.adjustName(name), value);
                continue;
            }
            catch (Exception e) {
                System.err.println("Error calling method in OutputFilter: " + name);
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public void destroy() {
    }
}

