/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.lang.reflect.Method;
import org.mentawai.core.Action;
import org.mentawai.core.Filter;
import org.mentawai.core.InvocationChain;
import org.mentawai.core.Output;
import org.mentawai.core.OutputWrapper;
import org.mentawai.core.PojoAction;
import org.mentawai.filter.ModelDriven;
import org.mentawai.jruby.JRubyInterpreter;
import org.mentawai.jruby.RubyAction;

public class OutjectionFilter
extends OutputWrapper
implements Filter {
    private ThreadLocal<Action> action = new ThreadLocal();

    private String adjustName(String name) {
        StringBuffer sb = new StringBuffer(name.length() - 3);
        sb.append(name.substring(3, 4).toLowerCase());
        sb.append(name.substring(4, name.length()));
        return sb.toString();
    }

    @Override
    public Object getValue(String key) {
        Object value = super.getValue(key);
        if (value != null) {
            return value;
        }
        Action action = this.action.get();
        if (action == null) {
            throw new IllegalStateException("No action was found!");
        }
        if (!(action instanceof RubyAction)) {
            throw new IllegalStateException("Action is not a Ruby Action!");
        }
        long rubyActionId = ((RubyAction)action).getRubyActionId();
        JRubyInterpreter ruby = JRubyInterpreter.getInstance();
        StringBuilder sb = new StringBuilder(64);
        sb.append("Mentawai::JRuby::Utils.get_prop(").append(rubyActionId).append(",'").append(key).append("')");
        value = ruby.eval(sb.toString());
        if (value != null) {
            super.setValue(key, value);
            return value;
        }
        return super.getValue(key);
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        String result = chain.invoke();
        Action action = chain.getAction();
        Output output = action.getOutput();
        boolean isModelDriven = false;
        boolean isPojoAction = false;
        boolean isRubyAction = false;
        if (action instanceof RubyAction) {
            isRubyAction = true;
        } else if (action instanceof ModelDriven) {
            isModelDriven = true;
        } else if (action instanceof PojoAction) {
            isPojoAction = true;
        }
        if (isRubyAction) {
            this.action.set(action);
            super.setOutput(action.getOutput());
            action.setOutput(this);
        } else {
            Method[] methods = null;
            if (isModelDriven) {
                ModelDriven md = (ModelDriven)((Object)action);
                methods = md.getModel().getClass().getMethods();
            } else if (isPojoAction) {
                PojoAction pa = (PojoAction)action;
                methods = pa.getPojo().getClass().getMethods();
            } else {
                methods = action.getClass().getDeclaredMethods();
            }
            for (int i = 0; i < methods.length; ++i) {
                String name = methods[i].getName();
                if (name.length() <= 3 || !name.startsWith("get") || methods[i].getParameterTypes().length != 0 || name.equals("getClass")) continue;
                try {
                    methods[i].setAccessible(true);
                    Object value = null;
                    if (isModelDriven) {
                        ModelDriven md = (ModelDriven)((Object)action);
                        value = methods[i].invoke(md.getModel(), (Object[])null);
                    } else if (isPojoAction) {
                        PojoAction pa = (PojoAction)action;
                        value = methods[i].invoke(pa.getPojo(), (Object[])null);
                    } else {
                        value = methods[i].invoke((Object)action, new Object[0]);
                    }
                    output.setValue(this.adjustName(name), value);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Error calling method in OutputFilter: " + name);
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    @Override
    public void destroy() {
    }
}

