/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.util.LinkedList;
import java.util.List;
import org.mentawai.core.Action;
import org.mentawai.core.BaseAction;
import org.mentawai.core.Filter;
import org.mentawai.core.InputWrapper;
import org.mentawai.core.InvocationChain;
import org.mentawai.i18n.LocaleManager;
import org.mentawai.message.ClassMessageContext;
import org.mentawai.message.DefaultMessage;
import org.mentawai.message.FileMessageContext;
import org.mentawai.message.Message;
import org.mentawai.message.MessageContext;
import org.mentawai.message.MessageManager;

public class MessagesFilter
extends InputWrapper
implements Filter {
    private final String name;

    public MessagesFilter(String name) {
        this.name = name;
    }

    private MessageContext getMessageContext(Action action) {
        if (LocaleManager.isUseMasterForEverything()) {
            return new FileMessageContext(LocaleManager.getMaster(), "");
        }
        return new ClassMessageContext(action.getClass());
    }

    private List<Message> getMessages(Action action) {
        return MessageManager.getMessages(action, true);
    }

    private void addMessage(Action action, String msg_id) {
        List<Message> messages = this.getMessages(action);
        messages.add(new DefaultMessage(msg_id, this.getMessageContext(action), BaseAction.getMessageTokens(action, null)));
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Action action = chain.getAction();
        super.setInput(action.getInput());
        action.setInput(this);
        String result = chain.invoke();
        List messages = (List)super.getValue(this.name);
        if (messages == null) {
            return result;
        }
        for (String value : messages) {
            this.addMessage(action, value);
        }
        return result;
    }

    @Override
    public Object getValue(String name) {
        if (name.equals(this.name)) {
            Object value = super.getValue(name);
            if (value != null) {
                return value;
            }
            LinkedList messages = new LinkedList();
            this.setValue(name, messages);
            return messages;
        }
        return super.getValue(name);
    }

    @Override
    public void destroy() {
    }
}

