/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import org.mentawai.core.Action;
import org.mentawai.core.AfterConsequenceFilter;
import org.mentawai.core.Consequence;
import org.mentawai.core.FilterException;
import org.mentawai.core.InputWrapper;
import org.mentawai.core.InvocationChain;
import org.mentawai.filter.ExceptionFilter;
import org.mentawai.transaction.JpaTransaction;
import org.mentawai.transaction.Transaction;

public class JpaFilter
extends InputWrapper
implements AfterConsequenceFilter {
    public static final String KEY = "jpa_entityManager";
    public static final String TRANS_KEY = "jpa_transaction";
    private EntityManagerFactory factory;
    private String jpaEntityManagerKey = "jpa_entityManager";
    private String jpaTransactionKey = "jpa_transaction";
    private ThreadLocal<EntityManager> jpaEntityManagerThreadLocal = new ThreadLocal();
    private ThreadLocal<Transaction> jpaTransactionThreadLocal = new ThreadLocal();
    private boolean transactional = false;
    private Set<String> resultsForRollback = new HashSet<String>();

    public JpaFilter(EntityManagerFactory factory) {
        this.factory = factory;
    }

    public JpaFilter(EntityManagerFactory factory, boolean transactional) {
        this.factory = factory;
        this.setTransactional(transactional);
    }

    public JpaFilter(String persistenceUnit) {
        this.factory = Persistence.createEntityManagerFactory((String)persistenceUnit);
    }

    public JpaFilter(String persistenceUnit, boolean transactional) {
        this.factory = Persistence.createEntityManagerFactory((String)persistenceUnit);
        this.setTransactional(transactional);
    }

    public JpaFilter(String persistenceUnit, boolean transactional, Map configOverrides) {
        this.factory = Persistence.createEntityManagerFactory((String)persistenceUnit, (Map)configOverrides);
        this.setTransactional(transactional);
    }

    public JpaFilter(String persistenceUnit, Map configOverrides) {
        this.factory = Persistence.createEntityManagerFactory((String)persistenceUnit, (Map)configOverrides);
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
        this.addResultsForRollback("error", ExceptionFilter.EXCEPTION);
    }

    public void addResultsForRollback(String ... results) {
        for (int i = 0; i < results.length; ++i) {
            this.resultsForRollback.add(results[i]);
        }
    }

    public void setTransactional(boolean transactional, String transactionKey) {
        this.setTransactional(transactional);
        this.jpaTransactionKey = transactionKey;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("JPAFilter: ").append("entityManagerKey=").append(this.jpaEntityManagerKey);
        sb.append(" transKey=").append(this.jpaTransactionKey);
        sb.append(" transactional=").append(this.transactional);
        return sb.toString();
    }

    public void setKey(String key) {
        this.jpaEntityManagerKey = key;
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Transaction trans;
        Action action = chain.getAction();
        super.setInput(action.getInput());
        action.setInput(this);
        String result = chain.invoke();
        if (this.transactional && (trans = this.jpaTransactionThreadLocal.get()) != null) {
            boolean shouldRollback;
            this.jpaTransactionThreadLocal.set(null);
            this.removeValue(this.jpaTransactionKey);
            boolean bl = shouldRollback = result == null || this.resultsForRollback.contains(result);
            if (!shouldRollback) {
                try {
                    trans.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new FilterException("Unable to commit jpa transaction!", e);
                }
            }
            try {
                trans.rollback();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new FilterException("Unable to rollback jpa transaction!", e);
            }
        }
        return result;
    }

    @Override
    public void afterConsequence(Action action, Consequence c, boolean conseqExecuted, boolean actionExecuted, String result) {
        EntityManager entityManager = this.jpaEntityManagerThreadLocal.get();
        if (entityManager != null) {
            this.jpaEntityManagerThreadLocal.set(null);
            this.removeValue(this.jpaEntityManagerKey);
            entityManager.close();
        }
    }

    @Override
    public void destroy() {
        this.factory.close();
    }

    @Override
    public Object getValue(String key) {
        if (key.equals(this.jpaEntityManagerKey)) {
            EntityManager entityManager = this.jpaEntityManagerThreadLocal.get();
            if (entityManager == null) {
                entityManager = this.factory.createEntityManager();
                this.jpaEntityManagerThreadLocal.set(entityManager);
                if (this.transactional) {
                    EntityTransaction tx = entityManager.getTransaction();
                    JpaTransaction trans = new JpaTransaction(entityManager, tx);
                    this.jpaTransactionThreadLocal.set(trans);
                    this.setValue(this.jpaTransactionKey, trans);
                }
                this.setValue(key, entityManager);
            }
            return entityManager;
        }
        return super.getValue(key);
    }
}

