/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import org.mentawai.core.Action;
import org.mentawai.core.ApplicationManager;
import org.mentawai.core.Context;
import org.mentawai.core.Filter;
import org.mentawai.core.FilterException;
import org.mentawai.core.InputWrapper;
import org.mentawai.core.InvocationChain;
import org.mentawai.filter.PushIoCFilter;
import org.mentawai.ioc.ActionComponent;
import org.mentawai.ioc.Bean;
import org.mentawai.ioc.ScopeComponent;

public class IoCFilter
extends InputWrapper
implements Filter {
    public static final int REQUEST = 11;
    public static final int SESSION = 3;
    public static final int APPLICATION = 4;
    private ThreadLocal<Action> action = new ThreadLocal();
    private Filter oldone = null;

    public IoCFilter() {
    }

    public IoCFilter(Bean comp, String key) {
        this.oldone = new PushIoCFilter(comp, key);
    }

    public IoCFilter(Bean comp, String key, int scope) {
        this.oldone = new PushIoCFilter(comp, key, scope);
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        if (this.oldone != null) {
            return this.oldone.filter(chain);
        }
        Action a = chain.getAction();
        this.action.set(a);
        super.setInput(a.getInput());
        a.setInput(this);
        return chain.invoke();
    }

    @Override
    public void destroy() {
        if (this.oldone != null) {
            this.oldone.destroy();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        if (this.oldone != null) {
            sb.append("IocFilter (deprecated one)");
        } else {
            sb.append("IoCFilter");
        }
        return sb.toString();
    }

    private Context getSession() {
        Action a = this.action.get();
        return a.getSession();
    }

    private Context getApplication() {
        Action a = this.action.get();
        return a.getApplication();
    }

    private Action getAction() {
        return this.action.get();
    }

    @Override
    public Object getValue(String key) {
        Object obj = super.getValue(key);
        if (obj != null) {
            return obj;
        }
        try {
            Bean c = ApplicationManager.getInstance().getComponent(key);
            if (c == null) {
                return null;
            }
            if (c instanceof ActionComponent) {
                ActionComponent ac = (ActionComponent)c;
                ac.setAction(this.getAction());
                ac.setKey(key);
                obj = c.getBean();
                if (obj != null) {
                    super.setValue(key, obj);
                }
                return obj;
            }
            if (c instanceof ScopeComponent) {
                int scope = ((ScopeComponent)c).getScope();
                if (scope == 4) {
                    obj = this.getApplication().getAttribute(key);
                    if (obj == null) {
                        obj = c.getBean();
                        this.getApplication().setAttribute(key, obj);
                    }
                } else if (scope == 3) {
                    obj = this.getSession().getAttribute(key);
                    if (obj == null) {
                        obj = c.getBean();
                        this.getSession().setAttribute(key, obj);
                    }
                } else if (scope == 11) {
                    obj = super.getValue(key);
                    if (obj == null) {
                        obj = c.getBean();
                        super.setValue(key, obj);
                    }
                } else {
                    throw new FilterException("Invalid scope for IoCInput: " + scope);
                }
                super.setValue(key, obj);
                return obj;
            }
            obj = c.getBean();
            if (obj != null) {
                super.setValue(key, obj);
            }
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("IoCFilter threw an Exception: " + e.getMessage(), e);
        }
    }
}

