/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.util.List;
import org.mentawai.core.Action;
import org.mentawai.core.Filter;
import org.mentawai.core.FilterException;
import org.mentawai.core.Input;
import org.mentawai.core.InvocationChain;
import org.mentawai.core.PojoAction;
import org.mentawai.filter.ModelDriven;
import org.mentawai.jruby.JRubyInterpreter;
import org.mentawai.jruby.RubyAction;
import org.mentawai.util.InjectionUtils;

public class InjectionFilter
implements Filter {
    private boolean tryField = true;
    private boolean convert = true;
    private boolean convertNullToFalse = false;

    public InjectionFilter() {
    }

    public InjectionFilter(boolean tryField) {
        this.tryField = tryField;
    }

    public InjectionFilter(boolean tryField, boolean convert) {
        this(tryField);
        this.convert = convert;
    }

    public InjectionFilter(boolean tryField, boolean convert, boolean convertNullToFalse) {
        this(tryField, convert);
        this.convertNullToFalse = convertNullToFalse;
    }

    protected Object getTarget(Action action) throws FilterException {
        Action actionImpl;
        Object pojo = null;
        if (action instanceof PojoAction) {
            PojoAction pa = (PojoAction)action;
            pojo = pa.getPojo();
        }
        Action action2 = actionImpl = pojo != null ? pojo : action;
        if (actionImpl instanceof ModelDriven) {
            ModelDriven md = (ModelDriven)((Object)action);
            Object model = md.getModel();
            if (model == null) {
                throw new FilterException("ModelDriven action cannot return a null model!");
            }
            return model;
        }
        return actionImpl;
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Action action = chain.getAction();
        if (action instanceof RubyAction) {
            JRubyInterpreter ruby = JRubyInterpreter.getInstance();
            Input input = action.getInput();
            Object rubyObject = ((RubyAction)action).getRubyObject();
            List<String> setters = ruby.getSetters(rubyObject);
            for (String m : setters) {
                String m_without = m.substring(0, m.length() - 1);
                Object value = input.getValue(m_without);
                if (value == null) continue;
                ruby.set(rubyObject, m, value);
            }
        } else {
            Object target = this.getTarget(action);
            InjectionUtils.getObject(target, action.getInput(), action.getLocale(), this.tryField, null, this.convert, this.convertNullToFalse, true);
        }
        return chain.invoke();
    }

    @Override
    public void destroy() {
    }
}

