/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.mentawai.core.Action;
import org.mentawai.core.AfterConsequenceFilter;
import org.mentawai.core.Consequence;
import org.mentawai.core.FilterException;
import org.mentawai.core.InputWrapper;
import org.mentawai.core.InvocationChain;
import org.mentawai.filter.ExceptionFilter;
import org.mentawai.transaction.HibernateTransaction;
import org.mentawai.transaction.Transaction;
import org.w3c.dom.Document;

public class HibernateFilter
extends InputWrapper
implements AfterConsequenceFilter {
    public static final String KEY = "session";
    public static final String TRANS_KEY = "transaction";
    private SessionFactory sessionFactory;
    private String hibernateSessionKey = "session";
    private String hibernateTransactionKey = "transaction";
    private ThreadLocal<Session> hibernateSessionThreadLocal = new ThreadLocal();
    private ThreadLocal<Transaction> hibernateTransactionThreadLocal = new ThreadLocal();
    private boolean transactional = false;
    private Set<String> resultsForRollback = new HashSet<String>();

    public HibernateFilter() {
        Configuration configuration = new Configuration().configure();
        this.init(configuration);
    }

    public HibernateFilter(boolean transactional) {
        this();
        this.setTransactional(transactional);
    }

    public HibernateFilter(Document document) {
        Configuration configuration = new Configuration().configure(document);
        this.init(configuration);
    }

    public HibernateFilter(boolean transactional, Document document) {
        this(document);
        this.setTransactional(transactional);
    }

    public HibernateFilter(File file) {
        Configuration configuration = new Configuration().configure(file);
        this.init(configuration);
    }

    public HibernateFilter(boolean transactional, File file) {
        this(file);
        this.setTransactional(transactional);
    }

    public HibernateFilter(URL url) {
        Configuration configuration = new Configuration().configure(url);
        this.init(configuration);
    }

    public HibernateFilter(boolean transactional, URL url) {
        this(url);
        this.setTransactional(transactional);
    }

    public HibernateFilter(String string) {
        Configuration configuration = new Configuration().configure(string);
        this.init(configuration);
    }

    public HibernateFilter(boolean transactional, String string) {
        this(string);
        this.setTransactional(transactional);
    }

    public HibernateFilter(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public HibernateFilter(boolean transactional, SessionFactory sessionFactory) {
        this(sessionFactory);
        this.setTransactional(transactional);
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
        this.addResultsForRollback("error", ExceptionFilter.EXCEPTION);
    }

    public void addResultsForRollback(String ... results) {
        for (int i = 0; i < results.length; ++i) {
            this.resultsForRollback.add(results[i]);
        }
    }

    public void setTransactional(boolean transactional, String transactionKey) {
        this.setTransactional(transactional);
        this.hibernateTransactionKey = transactionKey;
    }

    private void init(Configuration configuration) {
        this.sessionFactory = configuration.buildSessionFactory();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("HibernateFilter: ").append("sessionKey=").append(this.hibernateSessionKey);
        sb.append(" transKey=").append(this.hibernateTransactionKey);
        sb.append(" transactional=").append(this.transactional);
        return sb.toString();
    }

    public void setKey(String key) {
        this.hibernateSessionKey = key;
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Transaction trans;
        Action action = chain.getAction();
        super.setInput(action.getInput());
        action.setInput(this);
        String result = chain.invoke();
        if (this.transactional && (trans = this.hibernateTransactionThreadLocal.get()) != null) {
            boolean shouldRollback;
            this.hibernateTransactionThreadLocal.set(null);
            this.removeValue(this.hibernateTransactionKey);
            boolean bl = shouldRollback = result == null || this.resultsForRollback.contains(result);
            if (!shouldRollback) {
                try {
                    trans.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        trans.rollback();
                    }
                    catch (Exception e2) {
                        throw new FilterException("Unable to rollback transaction after a commit error !", e);
                    }
                    throw new FilterException("Unable to commit hibernate transaction!", e);
                }
            }
            try {
                trans.rollback();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new FilterException("Unable to rollback hibernate transaction!", e);
            }
        }
        return result;
    }

    @Override
    public void afterConsequence(Action action, Consequence c, boolean conseqExecuted, boolean actionExecuted, String result) {
        Session session = this.hibernateSessionThreadLocal.get();
        if (session != null) {
            this.hibernateSessionThreadLocal.set(null);
            this.removeValue(this.hibernateSessionKey);
            session.close();
        }
    }

    @Override
    public void destroy() {
        this.sessionFactory.close();
    }

    @Override
    public Object getValue(String key) {
        if (key.equals(this.hibernateSessionKey)) {
            Session session = this.hibernateSessionThreadLocal.get();
            if (session == null) {
                session = this.openSessionHibernate(this.sessionFactory);
                this.hibernateSessionThreadLocal.set(session);
                if (this.transactional) {
                    org.hibernate.Transaction tx = session.beginTransaction();
                    HibernateTransaction trans = new HibernateTransaction(session, tx);
                    this.hibernateTransactionThreadLocal.set(trans);
                    this.setValue(this.hibernateTransactionKey, trans);
                }
                this.setValue(key, session);
            }
            return session;
        }
        return super.getValue(key);
    }

    protected Session openSessionHibernate(SessionFactory sessionFactory) {
        return sessionFactory.openSession();
    }
}

