/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.util.HashMap;
import java.util.Iterator;
import org.mentawai.core.Action;
import org.mentawai.core.Filter;
import org.mentawai.core.Input;
import org.mentawai.core.InputWrapper;
import org.mentawai.core.InvocationChain;

public class HeadersFilter
extends InputWrapper
implements Filter {
    private final String name;
    private ThreadLocal<Action> action = new ThreadLocal();

    public HeadersFilter(String name) {
        this.name = name;
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Action action = chain.getAction();
        super.setInput(action.getInput());
        action.setInput(this);
        this.action.set(action);
        return chain.invoke();
    }

    @Override
    public Object getValue(String name) {
        if (name.equals(this.name)) {
            Object value = super.getValue(name);
            if (value != null) {
                return value;
            }
            Action action = this.action.get();
            if (action == null) {
                throw new IllegalStateException("Action cannot be null here!");
            }
            Input input = action.getInput();
            HashMap<String, String> headers = new HashMap<String, String>();
            Iterator<String> iter = input.getHeaderKeys();
            while (iter.hasNext()) {
                String key = iter.next();
                headers.put(key, input.getHeader(key));
            }
            this.setValue(name, headers);
            return headers;
        }
        return super.getValue(name);
    }

    @Override
    public void destroy() {
    }
}

