/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.mentawai.core.Action;
import org.mentawai.core.Filter;
import org.mentawai.core.FilterException;
import org.mentawai.core.InvocationChain;
import org.mentawai.core.Output;
import org.mentawai.filter.ValidatorFilter;
import org.mentawai.formatter.Formattable;
import org.mentawai.formatter.Formatter;
import org.mentawai.formatter.FormatterManager;

public class FormatterFilter
implements Filter {
    private Map<ValidatorFilter.ActionUniqueId, Map> cache = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String filter(InvocationChain chain) throws Exception {
        String result = chain.invoke();
        Action action = chain.getAction();
        Object pojo = chain.getPojo();
        Object actionImpl = pojo != null ? pojo : action;
        Locale loc = action.getLocale();
        Output output = action.getOutput();
        if (!(actionImpl instanceof Formattable)) {
            return result;
        }
        ValidatorFilter.ActionUniqueId actionId = new ValidatorFilter.ActionUniqueId(actionImpl.getClass().getName(), chain.getInnerAction());
        HashMap<String, Formatter> formatters = this.cache.get(actionId);
        if (formatters == null) {
            FormatterFilter formatterFilter = this;
            synchronized (formatterFilter) {
                if (formatters == null) {
                    formatters = new HashMap<String, Formatter>();
                    Formattable formattable = (Formattable)actionImpl;
                    formattable.initFormatters(formatters, chain.getInnerAction());
                    this.cache.put(actionId, formatters);
                }
            }
        }
        for (String field : formatters.keySet()) {
            Object toFormat = output.getValue(field);
            if (toFormat == null) continue;
            Object o = formatters.get(field);
            Formatter f = null;
            if (o instanceof String) {
                String s = (String)o;
                f = FormatterManager.getFormatter(s);
                if (f == null) {
                    throw new FilterException("Cannot find a formatter with this name: " + s);
                }
            } else if (o instanceof Formatter) {
                f = (Formatter)o;
            } else {
                throw new FilterException("Formatter must be a String or a Formatter!");
            }
            String formatted = f.format(toFormat, loc);
            output.setValue(field, formatted);
        }
        return result;
    }

    @Override
    public void destroy() {
    }
}

