/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.mentawai.core.Action;
import org.mentawai.core.Filter;
import org.mentawai.core.FilterException;
import org.mentawai.core.InvocationChain;
import org.mentawai.core.Output;
import org.mentawai.formatter.Formatter;
import org.mentawai.formatter.FormatterManager;

public abstract class FormatFilter
implements Filter {
    private Map<String, Object> formatters = new HashMap<String, Object>();
    private boolean isLoaded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getFormatters() {
        if (this.isLoaded) {
            return this.formatters;
        }
        FormatFilter formatFilter = this;
        synchronized (formatFilter) {
            if (!this.isLoaded) {
                this.initFormatters();
                this.isLoaded = true;
            }
        }
        return this.formatters;
    }

    public abstract void initFormatters();

    public FormatFilter add(String field, Formatter formatter) {
        this.formatters.put(field, formatter);
        return this;
    }

    public FormatFilter add(String field, String formatterName) {
        this.formatters.put(field, formatterName);
        return this;
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        String result = chain.invoke();
        Action action = chain.getAction();
        Locale loc = action.getLocale();
        Output output = action.getOutput();
        Map<String, Object> formatters = this.getFormatters();
        for (String field : formatters.keySet()) {
            Object toFormat = output.getValue(field);
            if (toFormat == null) continue;
            Object o = formatters.get(field);
            Formatter f = null;
            if (o instanceof String) {
                String s = (String)o;
                f = FormatterManager.getFormatter(s);
                if (f == null) {
                    throw new FilterException("Cannot find a formatter with this name: " + s);
                }
            } else if (o instanceof Formatter) {
                f = (Formatter)o;
            }
            String formatted = f.format(toFormat, loc);
            output.setValue(field, formatted);
        }
        return result;
    }

    @Override
    public void destroy() {
    }
}

