/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.io.File;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.mentawai.core.Action;
import org.mentawai.core.ApplicationManager;
import org.mentawai.core.Context;
import org.mentawai.core.Filter;
import org.mentawai.core.FilterException;
import org.mentawai.core.Input;
import org.mentawai.core.InvocationChain;
import org.mentawai.core.SessionContext;

public class FileUploadFilter
implements Filter {
    private final DiskFileItemFactory factory = new DiskFileItemFactory();
    private int maxSizeToThrowError = 0;

    public FileUploadFilter() {
    }

    public FileUploadFilter(int maxInMemorySize) {
        this(maxInMemorySize, 0, null);
    }

    public FileUploadFilter(int maxInMemorySize, int maxSizeToThrowError) {
        this(maxInMemorySize, maxSizeToThrowError, null);
    }

    public FileUploadFilter(int maxInMemorySize, int maxSizeToThrowError, String tempDirInsideWebInf) {
        this.factory.setSizeThreshold(maxInMemorySize);
        if (tempDirInsideWebInf != null) {
            StringBuilder sb = new StringBuilder(ApplicationManager.getRealPath());
            sb.append(File.separator).append("WEB-INF").append(File.separator);
            sb.append(tempDirInsideWebInf);
            File file = new File(sb.toString());
            if (!file.exists() && !file.mkdir()) {
                throw new IllegalStateException("Cannot create directory: " + file);
            }
            this.factory.setRepository(file);
        }
        this.maxSizeToThrowError = maxSizeToThrowError;
    }

    protected HttpServletRequest getRequest(Action action) {
        Context session = action.getSession();
        if (!(session instanceof SessionContext)) {
            return null;
        }
        return ((SessionContext)action.getSession()).getRequest();
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Action action = chain.getAction();
        Input input = action.getInput();
        HttpServletRequest req = this.getRequest(action);
        if (req == null) {
            throw new FilterException("I was not possible to fetch HttpServletRequest inside FileUploadFilter!!!");
        }
        try {
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)this.factory);
                if (this.maxSizeToThrowError > 0) {
                    upload.setSizeMax((long)this.maxSizeToThrowError);
                }
                List items = upload.parseRequest(req);
                for (FileItem item : items) {
                    String name = item.getFieldName();
                    if (item.isFormField()) {
                        String[] array;
                        String[] s;
                        String value = item.getString();
                        Object currValue = input.getValue(name);
                        if (currValue == null) {
                            input.setValue(name, value);
                            continue;
                        }
                        if (currValue instanceof String) {
                            s = (String[])currValue;
                            array = new String[]{s, value};
                            input.setValue(name, array);
                            continue;
                        }
                        if (currValue instanceof String[]) {
                            s = (String[])currValue;
                            array = new String[s.length + 1];
                            System.arraycopy(s, 0, array, 0, s.length);
                            array[array.length - 1] = value;
                            input.setValue(name, array);
                            continue;
                        }
                        throw new FilterException("Error trying to add a field value: " + name);
                    }
                    if (item.getSize() > 0L) {
                        input.setValue(name, item);
                        continue;
                    }
                    input.removeValue(name);
                }
            }
        }
        catch (FileUploadException e) {
            throw new FilterException(e);
        }
        return chain.invoke();
    }

    @Override
    public void destroy() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("FileUploadFilter: Class=").append(this.getClass().getName());
        return sb.toString();
    }
}

