/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.util.HashMap;
import java.util.Map;
import org.mentawai.core.Action;
import org.mentawai.core.BaseAction;
import org.mentawai.core.Filter;
import org.mentawai.core.InputWrapper;
import org.mentawai.core.InvocationChain;
import org.mentawai.core.PojoAction;
import org.mentawai.i18n.LocaleManager;
import org.mentawai.message.ClassMessageContext;
import org.mentawai.message.DefaultMessage;
import org.mentawai.message.FileMessageContext;
import org.mentawai.message.Message;
import org.mentawai.message.MessageContext;
import org.mentawai.message.MessageManager;

public class FieldErrorsFilter
extends InputWrapper
implements Filter {
    private final String name;
    private boolean alwaysReturnError = false;

    public FieldErrorsFilter(String name) {
        this.name = name;
    }

    public FieldErrorsFilter(String name, boolean alwaysReturnError) {
        this(name);
        this.alwaysReturnError = alwaysReturnError;
    }

    private MessageContext getMessageContext(Action action) {
        if (LocaleManager.isUseMasterForEverything()) {
            return new FileMessageContext(LocaleManager.getMaster(), "");
        }
        return new ClassMessageContext(action.getClass());
    }

    private Map<String, Message> getFieldErrors(Action action) {
        return MessageManager.getFieldErrors(action, true);
    }

    private void addError(Action action, String field, String error_id) {
        Map<String, Message> fieldErrors = this.getFieldErrors(action);
        fieldErrors.put(field, new DefaultMessage(error_id, this.getMessageContext(action), BaseAction.getMessageTokens(action, field)));
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Action action = chain.getAction();
        super.setInput(action.getInput());
        action.setInput(this);
        String result = chain.invoke();
        Map fieldErrors = (Map)super.getValue(this.name);
        if (fieldErrors == null) {
            return result;
        }
        for (String key : fieldErrors.keySet()) {
            String value = (String)fieldErrors.get(key);
            this.addError(action, key, value);
        }
        if (fieldErrors.size() > 0) {
            if (this.alwaysReturnError) {
                return "error";
            }
            Object actionResult = action.getOutput().getValue(PojoAction.RESULT);
            if (actionResult != null && !(actionResult instanceof String)) {
                return "error";
            }
        }
        return result;
    }

    @Override
    public Object getValue(String name) {
        if (name.equals(this.name)) {
            Object value = super.getValue(name);
            if (value != null) {
                return value;
            }
            HashMap fieldErrors = new HashMap();
            this.setValue(name, fieldErrors);
            return fieldErrors;
        }
        return super.getValue(name);
    }

    @Override
    public void destroy() {
    }
}

